/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderCanvas;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.Renderer;
import java.awt.Component;
import java.awt.Dimension;

public class OnscreenRenderTarget
extends RenderTarget
implements edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget {
    private RenderCanvas m_renderCanvas;
    private boolean m_isRepaintAlreadyCalled = false;

    OnscreenRenderTarget(Renderer renderer) {
        super(renderer);
        this.m_renderCanvas = renderer.createRenderCanvas(this);
    }

    @Override
    public Component getAWTComponent() {
        return this.m_renderCanvas;
    }

    @Override
    public Dimension getSize(Dimension rv) {
        Component awtComponent = this.getAWTComponent();
        if (awtComponent != null) {
            awtComponent.getSize(rv);
        } else {
            rv.width = 0;
            rv.height = 0;
        }
        return rv;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        if (!this.m_isRepaintAlreadyCalled) {
            this.getAWTComponent().repaint();
            this.m_isRepaintAlreadyCalled = true;
        }
    }

    @Override
    public synchronized void clearAndRenderOffscreen() {
        if (this.m_renderCanvas.acquireDrawingSurface()) {
            try {
                super.clearAndRenderOffscreen();
            }
            finally {
                this.m_renderCanvas.releaseDrawingSurface();
            }
        }
    }

    public synchronized void update() {
        if (this.m_renderCanvas.acquireDrawingSurface()) {
            try {
                this.m_renderCanvas.swapBuffers();
                this.m_isRepaintAlreadyCalled = false;
            }
            finally {
                this.m_renderCanvas.releaseDrawingSurface();
            }
        }
    }
}

