/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractProxyRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ContainerProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer.SceneProxy;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;

public abstract class ComponentProxy
extends ElementProxy {
    private SceneProxy m_sceneProxy = null;
    private static Vector s_changed = new Vector();

    protected abstract void onAbsoluteTransformationChange(Matrix4d var1);

    protected abstract void addToScene(SceneProxy var1);

    protected abstract void removeFromScene(SceneProxy var1);

    protected boolean listenToHierarchyAndAbsoluteTransformationChanges() {
        return ((Renderer)this.getRenderer()).requiresHierarchyAndAbsoluteTransformationListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateAbsoluteTransformationChanges() {
        Vector vector = s_changed;
        synchronized (vector) {
            if (s_changed.size() > 0) {
                Enumeration enum0 = s_changed.elements();
                while (enum0.hasMoreElements()) {
                    ComponentProxy componentProxy = (ComponentProxy)enum0.nextElement();
                    Component sgComponent = componentProxy.getSceneGraphComponent();
                    if (sgComponent == null) continue;
                    Matrix4d m = sgComponent.getAbsoluteTransformation();
                    componentProxy.onAbsoluteTransformationChange(m);
                }
                s_changed.removeAllElements();
            }
        }
    }

    private Component getSceneGraphComponent() {
        return (Component)this.getSceneGraphElement();
    }

    @Override
    public void initialize(Element sgElement, AbstractProxyRenderer renderer) {
        super.initialize(sgElement, renderer);
        if (this.listenToHierarchyAndAbsoluteTransformationChanges()) {
            this.onAbsoluteTransformationChange();
            this.onHierarchyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAbsoluteTransformationChange() {
        Vector vector = s_changed;
        synchronized (vector) {
            if (!s_changed.contains(this)) {
                s_changed.addElement(this);
            }
        }
    }

    public void onHierarchyChange() {
        ContainerProxy rootProxy = (ContainerProxy)this.getProxyFor(this.getSceneGraphComponent().getRoot());
        if (rootProxy != this.m_sceneProxy) {
            if (this.m_sceneProxy != null) {
                this.removeFromScene(this.m_sceneProxy);
            }
            this.m_sceneProxy = rootProxy instanceof SceneProxy ? (SceneProxy)rootProxy : null;
            if (this.m_sceneProxy != null) {
                this.addToScene(this.m_sceneProxy);
            }
        }
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property != Component.PARENT_PROPERTY) {
            super.changed(property, value);
        }
    }
}

