/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.ProjectionCamera;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.CameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Context;
import java.awt.Rectangle;
import java.nio.DoubleBuffer;
import javax.vecmath.Matrix4d;

class ProjectionCameraProxy
extends CameraProxy {
    private double[] m_projection = new double[16];
    private DoubleBuffer m_projectionBuffer = DoubleBuffer.wrap(this.m_projection);

    ProjectionCameraProxy() {
    }

    @Override
    protected Rectangle getActualLetterboxedViewport(int width, int height) {
        return new Rectangle(0, 0, width, height);
    }

    @Override
    protected double[] getActualNearPlane(double[] ret, int width, int height, double near) {
        ret[0] = Double.NaN;
        ret[1] = Double.NaN;
        ret[2] = Double.NaN;
        ret[3] = Double.NaN;
        return ret;
    }

    @Override
    protected void projection(Context context, int width, int height, float near, float far) {
        context.gl.glLoadMatrixd(this.m_projectionBuffer);
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == ProjectionCamera.PROJECTION_PROPERTY) {
            ProjectionCameraProxy.copy(this.m_projection, (Matrix4d)value);
        } else {
            super.changed(property, value);
        }
    }
}

