/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Context;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickParameters;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.VisualProxy;
import java.util.Hashtable;
import javax.media.opengl.GLAutoDrawable;

class PickContext
extends Context {
    private RenderTarget m_renderTarget;
    private Hashtable m_pickNameMap = new Hashtable();
    private PickParameters m_pickParameters;
    private edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickInfo m_pickInfo;

    public PickContext(RenderTarget renderTarget) {
        this.m_renderTarget = renderTarget;
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        super.display(drawable);
        if (this.m_pickParameters != null) {
            this.m_renderTarget.commitAnyPendingChanges();
            this.m_pickNameMap.clear();
            try {
                this.m_pickInfo = this.m_renderTarget.performPick(this, this.m_pickParameters);
            }
            finally {
                this.m_pickParameters = null;
            }
        }
    }

    public PickInfo pick(GLAutoDrawable drawable, int x, int y, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        this.m_pickParameters = new PickParameters(x, y, isSubElementRequired, isOnlyFrontMostRequired);
        drawable.display();
        return this.m_pickInfo;
    }

    public int getPickNameForVisualProxy(VisualProxy visualProxy) {
        int name = this.m_pickNameMap.size();
        this.m_pickNameMap.put(new Integer(name), visualProxy);
        return name;
    }

    public VisualProxy getPickVisualProxyForName(int name) {
        return (VisualProxy)this.m_pickNameMap.get(new Integer(name));
    }

    protected void renderPickVertex(Vertex3d vertex) {
        this.gl.glVertex3d(vertex.position.x, vertex.position.y, -vertex.position.z);
    }
}

