/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.CameraProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Context;
import java.awt.Rectangle;

class OrthographicCameraProxy
extends CameraProxy {
    private double[] m_plane = new double[4];
    private double[] reuse_actualNearPlane = new double[4];

    OrthographicCameraProxy() {
    }

    @Override
    protected Rectangle getActualLetterboxedViewport(int width, int height) {
        return new Rectangle(0, 0, width, height);
    }

    @Override
    protected double[] getActualNearPlane(double[] ret, int width, int height, double near) {
        double minX = this.m_plane[0];
        double maxX = this.m_plane[2];
        double minY = this.m_plane[1];
        double maxY = this.m_plane[3];
        if (Double.isNaN(minX) || Double.isNaN(maxX)) {
            if (Double.isNaN(minY) || Double.isNaN(maxY)) {
                minY = -1.0;
                maxY = 1.0;
            }
            double factor = (double)width / (double)height;
            minX = factor * minY;
            maxX = factor * maxY;
        } else if (Double.isNaN(minY) || Double.isNaN(maxY)) {
            double factor = (double)height / (double)width;
            minY = factor * minX;
            maxY = factor * maxY;
        }
        ret[0] = minX;
        ret[1] = minY;
        ret[2] = maxX;
        ret[3] = maxY;
        return ret;
    }

    @Override
    protected void projection(Context context, int width, int height, float near, float far) {
        this.getActualNearPlane(this.reuse_actualNearPlane, width, height);
        context.gl.glOrtho(this.reuse_actualNearPlane[0], this.reuse_actualNearPlane[2], this.reuse_actualNearPlane[1], this.reuse_actualNearPlane[3], (double)near, (double)far);
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == OrthographicCamera.PLANE_PROPERTY) {
            double[] plane = (double[])value;
            System.arraycopy(plane, 0, this.m_plane, 0, this.m_plane.length);
        } else {
            super.changed(property, value);
        }
    }
}

