/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Light;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.AffectorProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.AmbientLightProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import java.nio.FloatBuffer;

abstract class LightProxy
extends AffectorProxy {
    private float[] m_colorTimesBrightness = new float[4];
    private float[] m_color = new float[4];
    private float m_brightness;
    private float m_range;
    private float[] reuse_position = new float[4];
    private float[] reuse_spotDirection = new float[3];
    private FloatBuffer reuse_positionBuffer = FloatBuffer.wrap(this.reuse_position);
    private FloatBuffer reuse_spotDirectionBuffer = FloatBuffer.wrap(this.reuse_spotDirection);
    private FloatBuffer m_colorTimesBrightnessBuffer = FloatBuffer.wrap(this.m_colorTimesBrightness);

    LightProxy() {
    }

    protected float[] getPosition(float[] rv) {
        rv[0] = 0.0f;
        rv[1] = 0.0f;
        rv[2] = -1.0f;
        rv[3] = 0.0f;
        return rv;
    }

    protected float[] getSpotDirection(float[] rv) {
        rv[0] = 0.0f;
        rv[1] = 0.0f;
        rv[2] = 1.0f;
        return rv;
    }

    protected float getSpotExponent() {
        return 0.0f;
    }

    protected float getSpotCutoff() {
        return 180.0f;
    }

    protected float getConstantAttenuation() {
        return 1.0f;
    }

    protected float getLinearAttenuation() {
        return 0.0f;
    }

    protected float getQuadraticAttenuation() {
        return 0.0f;
    }

    protected void setup(RenderContext context, int id) {
        context.gl.glEnable(id);
        context.gl.glLightfv(id, 4609, this.m_colorTimesBrightnessBuffer);
        context.gl.glLightfv(id, 4610, this.m_colorTimesBrightnessBuffer);
        this.getPosition(this.reuse_position);
        context.gl.glLightfv(id, 4611, this.reuse_positionBuffer);
        this.getSpotDirection(this.reuse_spotDirection);
        context.gl.glLightfv(id, 4612, this.reuse_spotDirectionBuffer);
        context.gl.glLightf(id, 4613, this.getSpotExponent());
        context.gl.glLightf(id, 4614, this.getSpotCutoff());
        context.gl.glLightf(id, 4615, this.getConstantAttenuation());
        context.gl.glLightf(id, 4616, this.getLinearAttenuation());
        context.gl.glLightf(id, 4617, this.getQuadraticAttenuation());
    }

    @Override
    public void setup(RenderContext context) {
        if (this instanceof AmbientLightProxy) {
            context.addAmbient(this.m_colorTimesBrightness);
        } else {
            int id = context.getNextLightID();
            this.setup(context, id);
        }
    }

    private void updateColorTimesBrightness() {
        this.m_colorTimesBrightness[0] = this.m_color[0] * this.m_brightness;
        this.m_colorTimesBrightness[1] = this.m_color[1] * this.m_brightness;
        this.m_colorTimesBrightness[2] = this.m_color[2] * this.m_brightness;
        this.m_colorTimesBrightness[3] = 1.0f;
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == Light.COLOR_PROPERTY) {
            LightProxy.copy(this.m_color, (Color)value);
            this.updateColorTimesBrightness();
        } else if (property == Light.BRIGHTNESS_PROPERTY) {
            this.m_brightness = ((Number)value).floatValue();
            this.updateColorTimesBrightness();
        } else if (property == Light.RANGE_PROPERTY) {
            this.m_range = ((Number)value).floatValue();
        } else {
            super.changed(property, value);
        }
    }
}

