/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import com.sun.opengl.util.j2d.TextRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public class Graphics
extends java.awt.Graphics {
    private RenderContext m_renderContext;
    private Color m_color = Color.black;
    private static int SINE_AND_COSINE_CACHE_LENGTH = 8;
    private static double[] s_cosines = null;
    private static double[] s_sines = null;
    private Font m_font = new Font(null, 0, 12);

    private static void cacheSinesAndCosinesIfNecessary() {
        if (s_cosines == null) {
            s_cosines = new double[SINE_AND_COSINE_CACHE_LENGTH];
            s_sines = new double[SINE_AND_COSINE_CACHE_LENGTH];
            double theta = 0.0;
            double dtheta = 1.5707963267948966 / (double)s_cosines.length;
            int i = 0;
            while (i < s_cosines.length) {
                Graphics.s_cosines[i] = Math.cos(theta);
                Graphics.s_sines[i] = Math.sin(theta);
                theta += dtheta;
                ++i;
            }
        }
    }

    protected Graphics(RenderContext renderContext) {
        this.m_renderContext = renderContext;
        this.setColor(this.m_color);
        int width = this.m_renderContext.getWidth();
        int height = this.m_renderContext.getHeight();
        this.m_renderContext.gl.glMatrixMode(5889);
        this.m_renderContext.gl.glLoadIdentity();
        this.m_renderContext.gl.glOrtho(0.0, (double)(width - 1), (double)(height - 1), 0.0, -1.0, 1.0);
        this.m_renderContext.gl.glMatrixMode(5888);
        this.m_renderContext.gl.glLoadIdentity();
        this.m_renderContext.gl.glDisable(2929);
        this.m_renderContext.gl.glDisable(2896);
        this.m_renderContext.gl.glDisable(2884);
        this.m_renderContext.setTextureMapProxy(null);
    }

    @Override
    public void dispose() {
        this.m_renderContext.gl.glFlush();
        this.m_renderContext = null;
    }

    @Override
    public java.awt.Graphics create() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void translate(int x, int y) {
        this.m_renderContext.gl.glTranslatef((float)x, (float)y, 0.0f);
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    @Override
    public void setColor(Color c) {
        this.m_color = c;
        this.m_renderContext.gl.glColor3ub((byte)this.m_color.getRed(), (byte)this.m_color.getGreen(), (byte)this.m_color.getBlue());
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public Font getFont() {
        return this.m_font;
    }

    @Override
    public void setFont(Font font) {
        this.m_font = font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Shape getClip() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setClip(Shape clip) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.m_renderContext.gl.glBegin(1);
        this.m_renderContext.gl.glVertex2i(x1, y1);
        this.m_renderContext.gl.glVertex2i(x2, y2);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.m_renderContext.gl.glBegin(9);
        this.m_renderContext.gl.glVertex2i(x, y);
        this.m_renderContext.gl.glVertex2i(x + width, y);
        this.m_renderContext.gl.glVertex2i(x + width, y + height);
        this.m_renderContext.gl.glVertex2i(x, y + height);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        throw new RuntimeException("not implemented");
    }

    private void glQuarterOval(double centerX, double centerY, double radiusX, double radiusY, int whichQuarter) {
        int n = s_cosines.length;
        int max = n - 1;
        int i = 0;
        while (i < n) {
            double sin;
            double cos;
            switch (whichQuarter) {
                case 0: {
                    cos = s_cosines[i];
                    sin = s_sines[i];
                    break;
                }
                case 1: {
                    cos = -s_cosines[max - i];
                    sin = s_sines[max - i];
                    break;
                }
                case 2: {
                    cos = -s_cosines[i];
                    sin = -s_sines[i];
                    break;
                }
                case 3: {
                    cos = s_cosines[max - i];
                    sin = -s_sines[max - i];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.m_renderContext.gl.glVertex2d(centerX + cos * radiusX, centerY + sin * radiusY);
            ++i;
        }
    }

    private void glRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Graphics.cacheSinesAndCosinesIfNecessary();
        int x1 = x + arcWidth;
        int x2 = x + width - arcWidth;
        int y1 = y + arcHeight;
        int y2 = y + height - arcHeight;
        this.glQuarterOval(x1, y1, arcWidth, arcHeight, 2);
        this.glQuarterOval(x2, y1, arcWidth, arcHeight, 3);
        this.glQuarterOval(x2, y2, arcWidth, arcHeight, 0);
        this.glQuarterOval(x1, y2, arcWidth, arcHeight, 1);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.m_renderContext.gl.glBegin(2);
        this.glRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.m_renderContext.gl.glBegin(6);
        this.glRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.m_renderContext.gl.glEnd();
    }

    private void glOval(int x, int y, int width, int height) {
        double radiusX = (double)width * 0.5;
        double radiusY = (double)height * 0.5;
        double centerX = (double)x + radiusX;
        double centerY = (double)y + radiusY;
        Graphics.cacheSinesAndCosinesIfNecessary();
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 0);
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 1);
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 2);
        this.glQuarterOval(centerX, centerY, radiusX, radiusY, 3);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.m_renderContext.gl.glBegin(2);
        this.glOval(x, y, width, height);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.m_renderContext.gl.glBegin(6);
        this.glOval(x, y, width, height);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        throw new RuntimeException("not implemented");
    }

    private void glPoly(int[] xPoints, int[] yPoints, int nPoints) {
        int i = 0;
        while (i < nPoints) {
            this.m_renderContext.gl.glVertex2i(xPoints[i], yPoints[i]);
            ++i;
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_renderContext.gl.glBegin(3);
        this.glPoly(xPoints, yPoints, nPoints);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_renderContext.gl.glBegin(2);
        this.glPoly(xPoints, yPoints, nPoints);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_renderContext.gl.glBegin(9);
        this.glPoly(xPoints, yPoints, nPoints);
        this.m_renderContext.gl.glEnd();
    }

    @Override
    public void drawString(String str, int x, int y) {
        TextRenderer renderer = new TextRenderer(this.m_font);
        renderer.beginRendering(this.m_renderContext.getWidth(), this.m_renderContext.getHeight());
        renderer.setColor(this.m_color);
        renderer.draw(str, x, this.m_renderContext.getHeight() - y);
        renderer.endRendering();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        throw new RuntimeException("not implemented");
    }
}

