/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.BackgroundProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.ComponentProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.Context;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.PickParameters;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.SceneProxy;
import java.awt.Rectangle;

abstract class CameraProxy
extends ComponentProxy {
    private BackgroundProxy m_backgroundProxy = null;
    private float m_near;
    private float m_far;
    private Rectangle m_viewport = null;
    private boolean m_isLetterboxedAsOpposedToDistorted = true;

    CameraProxy() {
    }

    protected abstract Rectangle getActualLetterboxedViewport(int var1, int var2);

    public Rectangle getActualViewport(int width, int height) {
        if (this.m_viewport != null) {
            return this.m_viewport;
        }
        if (this.m_isLetterboxedAsOpposedToDistorted) {
            return this.getActualLetterboxedViewport(width, height);
        }
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getViewport() {
        return this.m_viewport;
    }

    public void setViewport(Rectangle viewport) {
        this.m_viewport = new Rectangle(viewport);
    }

    public boolean isLetterboxedAsOpposedToDistorted() {
        return this.m_isLetterboxedAsOpposedToDistorted;
    }

    public void setIsLetterboxedAsOpposedToDistorted(boolean isLetterboxedAsOpposedToDistorted) {
        this.m_isLetterboxedAsOpposedToDistorted = isLetterboxedAsOpposedToDistorted;
    }

    protected abstract double[] getActualNearPlane(double[] var1, int var2, int var3, double var4);

    public double[] getActualNearPlane(double[] ret, int width, int height) {
        return this.getActualNearPlane(ret, width, height, this.m_near);
    }

    @Override
    public void setup(RenderContext context) {
    }

    protected abstract void projection(Context var1, int var2, int var3, float var4, float var5);

    public void performClearAndRenderOffscreen(RenderContext context) {
        SceneProxy sceneProxy = this.getSceneProxy();
        if (sceneProxy != null) {
            Rectangle actualViewport = this.getActualViewport(context.getWidth(), context.getHeight());
            BackgroundProxy backgroundProxy = this.m_backgroundProxy != null ? this.m_backgroundProxy : sceneProxy.getBackgroundProxy();
            context.clear(backgroundProxy, actualViewport);
            context.gl.glMatrixMode(5889);
            context.gl.glLoadIdentity();
            this.projection(context, actualViewport.width, actualViewport.height, this.m_near, this.m_far);
            context.gl.glMatrixMode(5888);
            context.gl.glLoadIdentity();
            context.gl.glLoadMatrixd(this.getInverseAbsoluteTransformationAsBuffer());
            sceneProxy.setup(context);
            context.setRenderOpaque();
            sceneProxy.render(context);
            context.gl.glBlendFunc(770, 771);
            context.gl.glEnable(3042);
            context.gl.glEnable(3008);
            context.gl.glAlphaFunc(516, 0.0f);
            context.setRenderTransparent();
            sceneProxy.render(context);
            context.gl.glDisable(3042);
        }
    }

    public void performPick(PickContext context, PickParameters pickParameters) {
        SceneProxy sceneProxy = this.getSceneProxy();
        if (sceneProxy != null) {
            int width = context.getWidth();
            int height = context.getHeight();
            this.projection(context, width, height, this.m_near, this.m_far);
            context.gl.glMatrixMode(5888);
            context.gl.glLoadIdentity();
            context.gl.glLoadMatrixd(this.getInverseAbsoluteTransformationAsBuffer());
            sceneProxy.pick(context, pickParameters);
        }
    }

    @Override
    public void render(RenderContext context) {
    }

    @Override
    public void pick(PickContext context, PickParameters pickParameters) {
    }

    @Override
    protected void changed(Property property, Object value) {
        if (property == Camera.NEAR_CLIPPING_PLANE_DISTANCE_PROPERTY) {
            this.m_near = ((Number)value).floatValue();
        } else if (property == Camera.FAR_CLIPPING_PLANE_DISTANCE_PROPERTY) {
            this.m_far = ((Number)value).floatValue();
        } else if (property == Camera.BACKGROUND_PROPERTY) {
            this.m_backgroundProxy = (BackgroundProxy)this.getProxyFor((Background)value);
        } else {
            super.changed(property, value);
        }
    }
}

