/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer;

import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.ElementProxy;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.RenderContext;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.joglrenderer.TextureMapProxy;
import java.nio.FloatBuffer;

class AppearanceProxy
extends ElementProxy {
    private boolean m_isShaded;
    private int style = 0;
    private boolean m_isAmbientLinkedToDiffuse;
    private float[] m_ambient = new float[4];
    private float[] m_diffuse = new float[4];
    private float[] m_specular = new float[4];
    private float[] m_emissive = new float[4];
    private float m_opacity = 1.0f;
    private float m_shininess;
    private int m_polygonMode;
    private TextureMapProxy m_diffuseColorMapProxy;
    private FloatBuffer m_ambientBuffer = FloatBuffer.wrap(this.m_ambient);
    private FloatBuffer m_diffuseBuffer = FloatBuffer.wrap(this.m_diffuse);
    private FloatBuffer m_specularBuffer = FloatBuffer.wrap(this.m_specular);
    private FloatBuffer m_emissiveBuffer = FloatBuffer.wrap(this.m_emissive);

    AppearanceProxy() {
    }

    public void setPipelineState(RenderContext context, int face) {
        context.setIsShadingEnabled(this.m_isShaded);
        this.m_diffuse[3] = this.m_opacity;
        if (this.m_isShaded) {
            if (this.style == 0) {
                context.gl.glShadeModel(7424);
            } else {
                context.gl.glShadeModel(7425);
            }
            if (this.m_isAmbientLinkedToDiffuse) {
                context.gl.glMaterialfv(face, 5634, this.m_diffuseBuffer);
            } else {
                context.gl.glMaterialfv(face, 4608, this.m_ambientBuffer);
                context.gl.glMaterialfv(face, 4609, this.m_diffuseBuffer);
            }
            context.gl.glMaterialfv(face, 4610, this.m_specularBuffer);
            context.gl.glMaterialfv(face, 5632, this.m_emissiveBuffer);
            context.gl.glMaterialf(face, 5633, this.m_shininess);
        }
        context.gl.glColor4f(this.m_diffuse[0], this.m_diffuse[1], this.m_diffuse[2], this.m_diffuse[3]);
        context.gl.glPolygonMode(face, this.m_polygonMode);
        context.setTextureMapProxy(this.m_diffuseColorMapProxy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void changed(Property property, Object value) {
        if (property == Appearance.AMBIENT_COLOR_PROPERTY) {
            boolean bl = this.m_isAmbientLinkedToDiffuse = value == null;
            if (this.m_isAmbientLinkedToDiffuse) return;
            AppearanceProxy.copy(this.m_ambient, (Color)value);
            return;
        } else if (property == Appearance.DIFFUSE_COLOR_PROPERTY) {
            AppearanceProxy.copy(this.m_diffuse, (Color)value);
            return;
        } else if (property == Appearance.FILLING_STYLE_PROPERTY) {
            if (value.equals(FillingStyle.SOLID)) {
                this.m_polygonMode = 6914;
                return;
            } else if (value.equals(FillingStyle.WIREFRAME)) {
                this.m_polygonMode = 6913;
                return;
            } else {
                if (!value.equals(FillingStyle.POINTS)) throw new RuntimeException();
                this.m_polygonMode = 6912;
            }
            return;
        } else if (property == Appearance.SHADING_STYLE_PROPERTY) {
            if (value == null || value.equals(ShadingStyle.NONE)) {
                this.m_isShaded = false;
                return;
            } else if (value.equals(ShadingStyle.FLAT)) {
                this.m_isShaded = true;
                this.style = 0;
                return;
            } else {
                if (!value.equals(ShadingStyle.SMOOTH)) throw new RuntimeException();
                this.m_isShaded = true;
                this.style = 1;
            }
            return;
        } else if (property == Appearance.OPACITY_PROPERTY) {
            this.m_opacity = ((Number)value).floatValue();
            return;
        } else if (property == Appearance.SPECULAR_HIGHLIGHT_COLOR_PROPERTY) {
            AppearanceProxy.copy(this.m_specular, (Color)value);
            return;
        } else if (property == Appearance.SPECULAR_HIGHLIGHT_EXPONENT_PROPERTY) {
            this.m_shininess = ((Number)value).floatValue();
            return;
        } else if (property == Appearance.EMISSIVE_COLOR_PROPERTY) {
            AppearanceProxy.copy(this.m_emissive, (Color)value);
            return;
        } else if (property == Appearance.DIFFUSE_COLOR_MAP_PROPERTY) {
            this.m_diffuseColorMapProxy = (TextureMapProxy)this.getProxyFor((TextureMap)value);
            return;
        } else {
            if (property == Appearance.OPACITY_MAP_PROPERTY || property == Appearance.EMISSIVE_COLOR_MAP_PROPERTY || property == Appearance.SPECULAR_HIGHLIGHT_COLOR_MAP_PROPERTY || property == Appearance.BUMP_MAP_PROPERTY || property == Appearance.DETAIL_MAP_PROPERTY) return;
            super.changed(property, value);
        }
    }

    public double Showing() {
        return this.m_opacity;
    }
}

