/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Affector;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Sphere;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Visual
extends Component {
    public static final Property FRONT_FACING_APPEARANCE_PROPERTY = new Property(Visual.class, "FRONT_FACING_APPEARANCE");
    public static final Property BACK_FACING_APPEARANCE_PROPERTY = new Property(Visual.class, "BACK_FACING_APPEARANCE");
    public static final Property GEOMETRY_PROPERTY = new Property(Visual.class, "GEOMETRY");
    public static final Property SCALE_PROPERTY = new Property(Visual.class, "SCALE");
    public static final Property IS_SHOWING_PROPERTY = new Property(Visual.class, "IS_SHOWING");
    public static final Property DISABLED_AFFECTORS_PROPERTY = new Property(Visual.class, "DISABLED_AFFECTORS");
    private Appearance m_frontFacingAppearance = null;
    private Appearance m_backFacingAppearance = null;
    private Geometry m_geometry = null;
    private Matrix3d m_scale = new Matrix3d();
    private boolean m_isShowing = true;
    private Affector[] m_disabledAffectors = null;

    public Visual() {
        this.m_scale.setIdentity();
    }

    @Override
    protected void releasePass1() {
        if (this.m_frontFacingAppearance != null) {
            Visual.warnln(String.valueOf(Messages.getString("WARNING__released_visual_")) + this + " " + Messages.getString("still_has_front_facing_appearance_") + this.m_frontFacingAppearance + ".");
            this.setFrontFacingAppearance(null);
        }
        if (this.m_backFacingAppearance != null) {
            Visual.warnln(String.valueOf(Messages.getString("WARNING__released_visual_")) + this + " " + Messages.getString("still_has_back_facing_appearance_") + this.m_frontFacingAppearance + ".");
            this.setBackFacingAppearance(null);
        }
        if (this.m_geometry != null) {
            Visual.warnln(String.valueOf(Messages.getString("WARNING__released_visual_")) + this + " " + Messages.getString("still_has_geometry_") + this.m_geometry + ".");
            this.setGeometry(null);
        }
        if (this.m_disabledAffectors != null && this.m_disabledAffectors.length > 0) {
            Visual.warnln(String.valueOf(Messages.getString("WARNING__released_visual_")) + this + " " + Messages.getString("still_has_disabled_affectors__"));
            int i = 0;
            while (i < this.m_disabledAffectors.length) {
                Visual.warnln("\t" + this.m_disabledAffectors[i]);
                ++i;
            }
            this.setDisabledAffectors(null);
        }
        super.releasePass1();
    }

    public Geometry getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(Geometry geometry) {
        if (Visual.notequal(this.m_geometry, geometry)) {
            this.m_geometry = geometry;
            this.onPropertyChange(GEOMETRY_PROPERTY);
        }
    }

    public Appearance getFrontFacingAppearance() {
        return this.m_frontFacingAppearance;
    }

    public void setFrontFacingAppearance(Appearance frontFacingAppearance) {
        if (Visual.notequal(this.m_frontFacingAppearance, frontFacingAppearance)) {
            this.m_frontFacingAppearance = frontFacingAppearance;
            this.onPropertyChange(FRONT_FACING_APPEARANCE_PROPERTY);
        }
    }

    public Appearance getBackFacingAppearance() {
        return this.m_backFacingAppearance;
    }

    public void setBackFacingAppearance(Appearance backFacingAppearance) {
        if (Visual.notequal(this.m_backFacingAppearance, backFacingAppearance)) {
            this.m_backFacingAppearance = backFacingAppearance;
            this.onPropertyChange(BACK_FACING_APPEARANCE_PROPERTY);
        }
    }

    public Matrix3d getScale() {
        return this.m_scale;
    }

    public void setScale(Matrix3d scale) {
        if (Visual.notequal(this.m_scale, scale)) {
            this.m_scale = scale;
            this.onPropertyChange(SCALE_PROPERTY);
        }
    }

    public boolean getIsShowing() {
        return this.m_isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        if (this.m_isShowing != isShowing) {
            this.m_isShowing = isShowing;
            this.onPropertyChange(IS_SHOWING_PROPERTY);
        }
    }

    public Affector[] getDisabledAffectors() {
        return this.m_disabledAffectors;
    }

    public void setDisabledAffectors(Affector[] disabledAffectors) {
        if (Visual.notequal(this.m_disabledAffectors, disabledAffectors)) {
            this.m_disabledAffectors = disabledAffectors;
            this.onPropertyChange(DISABLED_AFFECTORS_PROPERTY);
        }
    }

    public Box getBoundingBox() {
        if (this.m_geometry != null) {
            Box box = this.m_geometry.getBoundingBox();
            if (box != null) {
                box.scale(this.m_scale);
            }
            return box;
        }
        return null;
    }

    public Sphere getBoundingSphere() {
        if (this.m_geometry != null) {
            Sphere sphere = this.m_geometry.getBoundingSphere();
            if (sphere != null) {
                sphere.scale(this.m_scale);
            }
            return sphere;
        }
        return null;
    }

    public void transform(Matrix4d trans) {
        Geometry geometry = this.getGeometry();
        if (geometry != null) {
            geometry.transform(trans);
        }
    }

    public boolean isInProjectionVolumeOf(Camera camera) {
        Sphere boundingSphere = this.getBoundingSphere();
        if (boundingSphere != null) {
            Matrix4d cameraProjection = camera.getProjection();
            Matrix4d cameraInverse = camera.getInverseAbsoluteTransformation();
            Matrix4d absolute = this.getAbsoluteTransformation();
            Matrix4d m = MathUtilities.multiply(absolute, MathUtilities.multiply(cameraInverse, cameraProjection));
            Vector4d centerV4 = MathUtilities.multiply(boundingSphere.getCenter(), 1.0, m);
            Vector3d centerV3 = MathUtilities.createVector3d((Tuple4d)centerV4);
            if (centerV3.x <= 1.0 && centerV3.x >= -1.0 && centerV3.y <= 1.0 && centerV3.y >= -1.0 && centerV3.z <= 1.0 && centerV3.z >= 0.0) {
                return true;
            }
        }
        return false;
    }
}

