/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Sphere;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class VertexGeometry
extends Geometry {
    public static final Property VERTICES_PROPERTY = new Property(VertexGeometry.class, "VERTICES");
    public static final Property VERTEX_LOWER_BOUND_PROPERTY = new Property(VertexGeometry.class, "VERTEX_LOWER_BOUND");
    public static final Property VERTEX_UPPER_BOUND_PROPERTY = new Property(VertexGeometry.class, "VERTEX_UPPER_BOUND");
    private Vertex3d[] m_vertices = null;
    private int m_vertexLowerBound = 0;
    private int m_vertexUpperBound = -1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void updateBoundingBox() {
        if (this.m_vertices != null && this.m_vertices.length > 0) {
            if (this.m_vertices[0] == null) throw new RuntimeException(this + " " + Messages.getString("vertex__0___has_somehow_become_null_"));
            Point3d min = new Point3d();
            Point3d max = new Point3d();
            Vertex3d v0 = this.m_vertices[0];
            min.set((Tuple3d)v0.position);
            max.set((Tuple3d)v0.position);
            int i = 1;
            while (i < this.m_vertices.length) {
                Vertex3d vi = this.m_vertices[i];
                min.x = Math.min(vi.position.x, min.x);
                min.y = Math.min(vi.position.y, min.y);
                min.z = Math.min(vi.position.z, min.z);
                max.x = Math.max(vi.position.x, max.x);
                max.y = Math.max(vi.position.y, max.y);
                max.z = Math.max(vi.position.z, max.z);
                ++i;
            }
            Vector3d minimum = new Vector3d(min.x, min.y, min.z);
            Vector3d maximum = new Vector3d(max.x, max.y, max.z);
            this.m_boundingBox = new Box(minimum, maximum);
            return;
        } else {
            this.m_boundingBox = null;
        }
    }

    private static double getDistanceSquaredBetween(Vertex3d vertex, Vector3d vector) {
        double dx = vertex.position.x - vector.x;
        double dy = vertex.position.y - vector.y;
        double dz = vertex.position.z - vector.z;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    protected void updateBoundingSphere() {
        Box box = this.getBoundingBox();
        if (box != null) {
            Vector3d center = box.getCenter();
            double distanceSquared = 0.0;
            int i = 0;
            while (i < this.m_vertices.length) {
                double d2 = VertexGeometry.getDistanceSquaredBetween(this.m_vertices[i], center);
                distanceSquared = Math.max(d2, distanceSquared);
                ++i;
            }
            this.m_boundingSphere = new Sphere(center, Math.sqrt(distanceSquared));
        }
    }

    public Vertex3d[] getVertices() {
        return this.m_vertices;
    }

    public void setVertices(Vertex3d[] vertices) {
        this.m_vertices = vertices;
        this.onPropertyChange(VERTICES_PROPERTY);
        this.onBoundsChange();
    }

    public int getVertexLowerBound() {
        return this.m_vertexLowerBound;
    }

    public void setVertexLowerBound(int vertexLowerBound) {
        if (this.m_vertexLowerBound != vertexLowerBound) {
            this.m_vertexLowerBound = vertexLowerBound;
            this.onPropertyChange(VERTEX_LOWER_BOUND_PROPERTY);
        }
    }

    public int getVertexUpperBound() {
        return this.m_vertexUpperBound;
    }

    public void setVertexUpperBound(int vertexUpperBound) {
        if (this.m_vertexUpperBound != vertexUpperBound) {
            this.m_vertexUpperBound = vertexUpperBound;
            this.onPropertyChange(VERTEX_UPPER_BOUND_PROPERTY);
        }
    }

    public int getVertexCount() {
        if (this.m_vertices != null) {
            return this.m_vertices.length;
        }
        return 0;
    }

    @Override
    public void transform(Matrix4d trans) {
        Vertex3d[] vertices = this.getVertices();
        int i = 0;
        while (i < vertices.length) {
            vertices[i].transform(trans);
            ++i;
        }
        this.setVertices(vertices);
    }

    public static Vertex3d[] loadVertices(InputStream is) throws IOException {
        Vertex3d[] vertices = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        int version = dis.readInt();
        if (version == 1) {
            int vertexCount = dis.readInt();
            vertices = new Vertex3d[vertexCount];
            int i = 0;
            while (i < vertices.length) {
                vertices[i] = new Vertex3d(19);
                vertices[i].position.x = dis.readDouble();
                vertices[i].position.y = dis.readDouble();
                vertices[i].position.z = dis.readDouble();
                vertices[i].normal.x = dis.readDouble();
                vertices[i].normal.y = dis.readDouble();
                vertices[i].normal.z = dis.readDouble();
                vertices[i].textureCoordinate0.x = (float)dis.readDouble();
                vertices[i].textureCoordinate0.y = (float)dis.readDouble();
                ++i;
            }
        } else if (version == 2) {
            int vertexCount = dis.readInt();
            vertices = new Vertex3d[vertexCount];
            int i = 0;
            while (i < vertices.length) {
                int format = dis.readInt();
                vertices[i] = new Vertex3d(format);
                if ((format & 1) != 0) {
                    vertices[i].position.x = dis.readDouble();
                    vertices[i].position.y = dis.readDouble();
                    vertices[i].position.z = dis.readDouble();
                }
                if ((format & 2) != 0) {
                    vertices[i].normal.x = dis.readDouble();
                    vertices[i].normal.y = dis.readDouble();
                    vertices[i].normal.z = dis.readDouble();
                }
                if ((format & 4) != 0) {
                    vertices[i].diffuseColor.red = (float)dis.readDouble();
                    vertices[i].diffuseColor.green = (float)dis.readDouble();
                    vertices[i].diffuseColor.blue = (float)dis.readDouble();
                    vertices[i].diffuseColor.alpha = (float)dis.readDouble();
                }
                if ((format & 0x10) != 0) {
                    vertices[i].textureCoordinate0.x = (float)dis.readDouble();
                    vertices[i].textureCoordinate0.y = (float)dis.readDouble();
                }
                ++i;
            }
        } else if (version == 3) {
            int vertexCount = dis.readInt();
            vertices = new Vertex3d[vertexCount];
            int i = 0;
            while (i < vertices.length) {
                int format = dis.readInt();
                vertices[i] = new Vertex3d(format);
                if ((format & 1) != 0) {
                    vertices[i].position.x = dis.readDouble();
                    vertices[i].position.y = dis.readDouble();
                    vertices[i].position.z = dis.readDouble();
                }
                if ((format & 2) != 0) {
                    vertices[i].normal.x = dis.readDouble();
                    vertices[i].normal.y = dis.readDouble();
                    vertices[i].normal.z = dis.readDouble();
                }
                if ((format & 4) != 0) {
                    vertices[i].diffuseColor.red = dis.readFloat();
                    vertices[i].diffuseColor.green = dis.readFloat();
                    vertices[i].diffuseColor.blue = dis.readFloat();
                    vertices[i].diffuseColor.alpha = dis.readFloat();
                }
                if ((format & 8) != 0) {
                    vertices[i].specularHighlightColor.red = dis.readFloat();
                    vertices[i].specularHighlightColor.green = dis.readFloat();
                    vertices[i].specularHighlightColor.blue = dis.readFloat();
                    vertices[i].specularHighlightColor.alpha = dis.readFloat();
                }
                if ((format & 0x10) != 0) {
                    vertices[i].textureCoordinate0.x = dis.readFloat();
                    vertices[i].textureCoordinate0.y = dis.readFloat();
                }
                ++i;
            }
        } else {
            throw new RuntimeException(String.valueOf(Messages.getString("invalid_file_version__")) + version);
        }
        return vertices;
    }

    public static void storeVertices(Vertex3d[] vertices, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(3);
        dos.writeInt(vertices.length);
        int i = 0;
        while (i < vertices.length) {
            int format = vertices[i].getFormat();
            dos.writeInt(format);
            if ((format & 1) != 0) {
                dos.writeDouble(vertices[i].position.x);
                dos.writeDouble(vertices[i].position.y);
                dos.writeDouble(vertices[i].position.z);
            }
            if ((format & 2) != 0) {
                dos.writeDouble(vertices[i].normal.x);
                dos.writeDouble(vertices[i].normal.y);
                dos.writeDouble(vertices[i].normal.z);
            }
            if ((format & 4) != 0) {
                dos.writeFloat(vertices[i].diffuseColor.red);
                dos.writeFloat(vertices[i].diffuseColor.green);
                dos.writeFloat(vertices[i].diffuseColor.blue);
                dos.writeFloat(vertices[i].diffuseColor.alpha);
            }
            if ((format & 8) != 0) {
                dos.writeFloat(vertices[i].specularHighlightColor.red);
                dos.writeFloat(vertices[i].specularHighlightColor.green);
                dos.writeFloat(vertices[i].specularHighlightColor.blue);
                dos.writeFloat(vertices[i].specularHighlightColor.alpha);
            }
            if ((format & 0x10) != 0) {
                dos.writeFloat(vertices[i].textureCoordinate0.x);
                dos.writeFloat(vertices[i].textureCoordinate0.y);
            }
            ++i;
        }
        dos.flush();
    }
}

