/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.math.Vector4;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Vertex3d
implements Cloneable,
Serializable {
    public static final int FORMAT_POSITION = 1;
    public static final int FORMAT_NORMAL = 2;
    public static final int FORMAT_DIFFUSE_COLOR = 4;
    public static final int FORMAT_SPECULAR_HIGHLIGHT_COLOR = 8;
    public static final int FORMAT_TEXTURE_COORDINATE_0 = 16;
    public Point3d position = null;
    public Vector3d normal = null;
    public Color diffuseColor = null;
    public Color specularHighlightColor = null;
    public TexCoord2f textureCoordinate0 = null;

    public Vertex3d() {
    }

    public Vertex3d(int format) {
        if ((format & 1) != 0) {
            this.position = new Point3d();
        }
        if ((format & 2) != 0) {
            this.normal = new Vector3d();
        }
        if ((format & 4) != 0) {
            this.diffuseColor = new Color();
        }
        if ((format & 8) != 0) {
            this.specularHighlightColor = new Color();
        }
        if ((format & 0x10) != 0) {
            this.textureCoordinate0 = new TexCoord2f();
        }
    }

    public Vertex3d(Point3d position, Vector3d normal, Color diffuseColor, Color specularHighlightColor, TexCoord2f textureCoordinate0) {
        this.position = position;
        this.normal = normal;
        this.diffuseColor = diffuseColor;
        this.specularHighlightColor = specularHighlightColor;
        this.textureCoordinate0 = textureCoordinate0;
    }

    public static Vertex3d createXYZIJKUV(double x, double y, double z, double i, double j, double k, float u, float v) {
        Vertex3d vertex = new Vertex3d();
        vertex.position = new Point3d(x, y, z);
        vertex.normal = new Vector3d(i, j, k);
        vertex.textureCoordinate0 = new TexCoord2f(u, v);
        return vertex;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Vertex3d) {
            Vertex3d v = (Vertex3d)o;
            if (v.position == null ? this.position != null : !v.position.equals((Tuple3d)this.position)) {
                return false;
            }
            if (v.normal == null ? this.normal != null : !v.normal.equals((Tuple3d)this.normal)) {
                return false;
            }
            if (v.diffuseColor == null ? this.diffuseColor != null : !v.diffuseColor.equals(this.diffuseColor)) {
                return false;
            }
            if (v.specularHighlightColor == null ? this.specularHighlightColor != null : !v.specularHighlightColor.equals(this.specularHighlightColor)) {
                return false;
            }
            return !(v.textureCoordinate0 == null ? this.textureCoordinate0 != null : !v.textureCoordinate0.equals((Tuple2f)this.textureCoordinate0));
        }
        return false;
    }

    public int getFormat() {
        int format = 0;
        if (this.position != null) {
            format |= 1;
        }
        if (this.normal != null) {
            format |= 2;
        }
        if (this.diffuseColor != null) {
            format |= 4;
        }
        if (this.specularHighlightColor != null) {
            format |= 8;
        }
        if (this.textureCoordinate0 != null) {
            format |= 0x10;
        }
        return format;
    }

    public void translate(double x, double y, double z) {
        this.position.x += x;
        this.position.y += y;
        this.position.z += z;
    }

    public void scale(double x, double y, double z) {
        this.position.x *= x;
        this.position.y *= y;
        this.position.z *= z;
    }

    public void transform(Matrix4d trans) {
        if (this.position != null) {
            Vector4 xyz1 = new Vector4(this.position.x, this.position.y, this.position.z, 1.0);
            xyz1.transform(trans);
            this.position.x = xyz1.x;
            this.position.y = xyz1.y;
            this.position.z = xyz1.z;
        }
        if (this.normal != null) {
            Vector4 ijk0 = new Vector4(this.normal.x, this.normal.y, this.normal.z, 0.0);
            ijk0.transform(trans);
            this.normal.x = ijk0.x;
            this.normal.y = ijk0.y;
            this.normal.z = ijk0.z;
        }
    }

    public String toString() {
        return "edu.cmu.cs.stage3.alice.scenegraph.Vertex3d[position=" + this.position + ",normal=" + this.normal + ",diffuseColor=" + this.diffuseColor + ",specularHighlightColor=" + this.specularHighlightColor + ",textureCoordinate0=" + this.textureCoordinate0 + "]";
    }
}

