/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Vector3;

public class Vertex
extends Vertex3d {
    public static final int POSITION_XYZ = 1;
    public static final int NORMAL_IJK = 2;
    public static final int DIFFUSE_RGBA = 4;
    public static final int SPECULAR_RGBA = 8;
    public static final int TEXTURE_COORDINATE_UV0 = 16;

    public Vertex(int format) {
        super(format);
    }

    public static Vertex createXYZVertex(double x, double y, double z) {
        Vertex vertex = new Vertex(1);
        vertex.setX(x);
        vertex.setY(y);
        vertex.setZ(z);
        return vertex;
    }

    public static Vertex createXYZDiffuseVertex(double x, double y, double z, Color color) {
        Vertex vertex = new Vertex(5);
        vertex.setX(x);
        vertex.setY(y);
        vertex.setZ(z);
        vertex.setR(color.getRed());
        vertex.setG(color.getGreen());
        vertex.setB(color.getBlue());
        vertex.setA(color.getAlpha());
        return vertex;
    }

    public static Vertex createXYZIJKUVVertex(double x, double y, double z, double i, double j, double k, double u, double v) {
        Vertex vertex = new Vertex(19);
        vertex.setX(x);
        vertex.setY(y);
        vertex.setZ(z);
        vertex.setI(i);
        vertex.setJ(j);
        vertex.setK(k);
        vertex.setU(u);
        vertex.setV(v);
        return vertex;
    }

    public double[] getArray() {
        int xyzOffset = -128;
        int ijkOffset = -128;
        int uvOffset = -128;
        int rgbaOffset = -128;
        int size = 0;
        int format = this.getFormat();
        if ((format & 1) != 0) {
            xyzOffset = size;
            size = (byte)(size + 3);
        }
        if ((format & 2) != 0) {
            ijkOffset = size;
            size = (byte)(size + 3);
        }
        if ((format & 4) != 0) {
            rgbaOffset = size;
            size = (byte)(size + 4);
        }
        if ((format & 8) != 0) {
            rgbaOffset = size;
            size = (byte)(size + 4);
        }
        if ((format & 0x10) != 0) {
            uvOffset = size;
            size = (byte)(size + 2);
        }
        double[] array = new double[size];
        if ((format & 1) != 0) {
            array[xyzOffset] = this.position.x;
            array[xyzOffset + 1] = this.position.y;
            array[xyzOffset + 2] = this.position.z;
        }
        if ((format & 2) != 0) {
            array[xyzOffset] = this.normal.x;
            array[xyzOffset + 1] = this.normal.y;
            array[xyzOffset + 2] = this.normal.z;
        }
        if ((format & 4) != 0) {
            array[xyzOffset] = this.diffuseColor.red;
            array[xyzOffset + 1] = this.diffuseColor.green;
            array[xyzOffset + 2] = this.diffuseColor.blue;
            array[xyzOffset + 3] = this.diffuseColor.alpha;
        }
        if ((format & 8) != 0) {
            array[xyzOffset] = this.specularHighlightColor.red;
            array[xyzOffset + 1] = this.specularHighlightColor.green;
            array[xyzOffset + 2] = this.specularHighlightColor.blue;
            array[xyzOffset + 3] = this.specularHighlightColor.alpha;
        }
        if ((format & 0x10) != 0) {
            array[xyzOffset] = this.textureCoordinate0.x;
            array[xyzOffset + 1] = this.textureCoordinate0.y;
        }
        return array;
    }

    public Vector3 getXYZ() {
        return new Vector3(this.getX(), this.getY(), this.getZ());
    }

    public void setXYZ(Vector3 v) {
        this.setX(v.x);
        this.setY(v.y);
        this.setZ(v.z);
    }

    public Vector3 getIJK() {
        return new Vector3(this.getI(), this.getJ(), this.getK());
    }

    public void setIJK(Vector3 v) {
        this.setI(v.x);
        this.setJ(v.y);
        this.setK(v.z);
    }

    public double getX() {
        if ((this.getFormat() & 1) != 0) {
            return this.position.x;
        }
        return Double.NaN;
    }

    public double getY() {
        if ((this.getFormat() & 1) != 0) {
            return this.position.y;
        }
        return Double.NaN;
    }

    public double getZ() {
        if ((this.getFormat() & 1) != 0) {
            return this.position.z;
        }
        return Double.NaN;
    }

    public double getI() {
        if ((this.getFormat() & 2) != 0) {
            return this.normal.x;
        }
        return Double.NaN;
    }

    public double getJ() {
        if ((this.getFormat() & 2) != 0) {
            return this.normal.y;
        }
        return Double.NaN;
    }

    public double getK() {
        if ((this.getFormat() & 2) != 0) {
            return this.normal.z;
        }
        return Double.NaN;
    }

    public double getU() {
        if ((this.getFormat() & 0x10) != 0) {
            return this.textureCoordinate0.x;
        }
        return Double.NaN;
    }

    public double getV() {
        if ((this.getFormat() & 0x10) != 0) {
            return this.textureCoordinate0.y;
        }
        return Double.NaN;
    }

    public double getR() {
        if ((this.getFormat() & 4) != 0) {
            return this.diffuseColor.red;
        }
        return Double.NaN;
    }

    public double getG() {
        if ((this.getFormat() & 4) != 0) {
            return this.diffuseColor.green;
        }
        return Double.NaN;
    }

    public double getB() {
        if ((this.getFormat() & 4) != 0) {
            return this.diffuseColor.blue;
        }
        return Double.NaN;
    }

    public double getA() {
        if ((this.getFormat() & 4) != 0) {
            return this.diffuseColor.alpha;
        }
        return Double.NaN;
    }

    public void setX(double x) {
        if ((this.getFormat() & 1) != 0) {
            this.position.x = x;
        } else if (!Double.isNaN(x)) {
            throw new RuntimeException();
        }
    }

    public void setY(double y) {
        if ((this.getFormat() & 1) != 0) {
            this.position.y = y;
        } else if (!Double.isNaN(y)) {
            throw new RuntimeException();
        }
    }

    public void setZ(double z) {
        if ((this.getFormat() & 1) != 0) {
            this.position.z = z;
        } else if (!Double.isNaN(z)) {
            throw new RuntimeException();
        }
    }

    public void setI(double i) {
        if ((this.getFormat() & 2) != 0) {
            this.normal.x = i;
        } else if (!Double.isNaN(i)) {
            throw new RuntimeException();
        }
    }

    public void setJ(double j) {
        if ((this.getFormat() & 2) != 0) {
            this.normal.y = j;
        } else if (!Double.isNaN(j)) {
            throw new RuntimeException();
        }
    }

    public void setK(double k) {
        if ((this.getFormat() & 2) != 0) {
            this.normal.z = k;
        } else if (!Double.isNaN(k)) {
            throw new RuntimeException();
        }
    }

    public void setU(double u) {
        if ((this.getFormat() & 0x10) != 0) {
            this.textureCoordinate0.x = (float)u;
        } else if (!Double.isNaN(u)) {
            throw new RuntimeException();
        }
    }

    public void setV(double v) {
        if ((this.getFormat() & 0x10) != 0) {
            this.textureCoordinate0.y = (float)v;
        } else if (!Double.isNaN(v)) {
            throw new RuntimeException();
        }
    }

    public void setR(double r) {
        if ((this.getFormat() & 4) != 0) {
            this.diffuseColor.red = (float)r;
        } else if (!Double.isNaN(r)) {
            throw new RuntimeException();
        }
    }

    public void setG(double g) {
        if ((this.getFormat() & 4) != 0) {
            this.diffuseColor.green = (float)g;
        } else if (!Double.isNaN(g)) {
            throw new RuntimeException();
        }
    }

    public void setB(double b) {
        if ((this.getFormat() & 4) != 0) {
            this.diffuseColor.blue = (float)b;
        } else if (!Double.isNaN(b)) {
            throw new RuntimeException();
        }
    }

    public void setA(double a) {
        if ((this.getFormat() & 4) != 0) {
            this.diffuseColor.alpha = (float)a;
        } else if (!Double.isNaN(a)) {
            throw new RuntimeException();
        }
    }

    @Override
    public String toString() {
        return "edu.cmu.cs.stage3.alice.scenegraph.Vertex[format=" + this.getFormat() + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",i=" + this.getI() + ",j=" + this.getJ() + ",k=" + this.getK() + ",u=" + this.getU() + ",v=" + this.getV() + ",r=" + this.getR() + ",g=" + this.getG() + ",b=" + this.getB() + ",a=" + this.getA() + "]";
    }

    public static Vertex valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.alice.scenegraph.Vertex[format=", ",x=", ",y=", ",z=", ",z=", ",i=", ",j=", ",k=", ",u=", ",v=", ",r=", ",g=", ",b=", ",a=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        Vertex v = new Vertex((int)values[0]);
        v.setX(values[1]);
        v.setY(values[2]);
        v.setZ(values[3]);
        v.setI(values[4]);
        v.setJ(values[5]);
        v.setK(values[6]);
        v.setU(values[7]);
        v.setV(values[8]);
        v.setR(values[9]);
        v.setG(values[10]);
        v.setB(values[11]);
        v.setA(values[12]);
        return v;
    }
}

