/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import java.awt.Image;

public class TextureMap
extends Element {
    public static final Property IMAGE_PROPERTY = new Property(TextureMap.class, "IMAGE");
    public static final Property FORMAT_PROPERTY = new Property(TextureMap.class, "FORMAT");
    public static final int RGB = 1;
    public static final int ALPHA = 2;
    public static final int RGBA = 3;
    public static final int LUMINANCE = 4;
    public static final int LUMINANCE_PLUS_ALPHA = 6;
    private int m_format = 1;
    private Image m_image = null;
    private RenderTarget m_renderTargetWithLatestImage = null;

    public Image getImage() {
        if (this.m_renderTargetWithLatestImage != null) {
            this.m_image = this.m_renderTargetWithLatestImage.getImage(this);
        }
        return this.m_image;
    }

    public void setImage(Image image) {
        if (this.m_image != image) {
            this.m_image = image;
            this.onPropertyChange(IMAGE_PROPERTY);
        }
        this.m_renderTargetWithLatestImage = null;
    }

    public void touchImage() {
        this.onPropertyChange(IMAGE_PROPERTY);
        this.m_renderTargetWithLatestImage = null;
    }

    public RenderTarget getRenderTargetWithLatestImage() {
        return this.m_renderTargetWithLatestImage;
    }

    public void setRenderTargetWithLatestImage(RenderTarget renderTargetWithLatestImage) {
        this.m_renderTargetWithLatestImage = renderTargetWithLatestImage;
    }

    public int getFormat() {
        return this.m_format;
    }

    public void setFormat(int format) {
        if (this.m_format != format) {
            this.m_format = format;
            this.onPropertyChange(FORMAT_PROPERTY);
        }
    }
}

