/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Matrix44;
import javax.vecmath.Matrix4d;

public class Scene
extends ReferenceFrame {
    public static final Property BACKGROUND_PROPERTY = new Property(Scene.class, "BACKGROUND");
    private Background m_background = null;

    @Override
    protected void releasePass1() {
        if (this.m_background != null) {
            Scene.warnln(String.valueOf(Messages.getString("WARNING__released_scene_")) + this + " " + Messages.getString("still_has_background_") + this.m_background + ".");
            this.setBackground(null);
        }
        super.releasePass1();
    }

    @Override
    public Matrix4d getAbsoluteTransformation() {
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    @Override
    public Matrix4d getInverseAbsoluteTransformation() {
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return m;
    }

    @Override
    public Container getRoot() {
        return this;
    }

    public Background getBackground() {
        return this.m_background;
    }

    public void setBackground(Background background) {
        if (this.m_background != background) {
            this.m_background = background;
            this.onPropertyChange(BACKGROUND_PROPERTY);
        }
    }

    @Override
    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        return new Matrix44(asSeenBy.getInverseAbsoluteTransformation());
    }
}

