/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class ReferenceFrame
extends Container {
    private static Transformable s_getTransformationHelperOffset = new Transformable();

    static {
        s_getTransformationHelperOffset.setName("s_getTransformationHelperOffset");
        s_getTransformationHelperOffset.setIsHelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix44 getTransformation(Vector3d offset, ReferenceFrame asSeenBy) {
        Transformable transformable = s_getTransformationHelperOffset;
        synchronized (transformable) {
            ReferenceFrame actual;
            Matrix44 m;
            if (offset != null) {
                s_getTransformationHelperOffset.setParent(this);
                m = new Matrix44();
                m.m30 = offset.x;
                m.m31 = offset.y;
                m.m32 = offset.z;
                s_getTransformationHelperOffset.setLocalTransformation(m);
                actual = s_getTransformationHelperOffset;
            } else {
                actual = this;
            }
            m = asSeenBy != null ? Matrix44.multiply(actual.getAbsoluteTransformation(), asSeenBy.getInverseAbsoluteTransformation()) : new Matrix44(actual.getAbsoluteTransformation());
            if (offset != null) {
                s_getTransformationHelperOffset.setParent(null);
            }
            return m;
        }
    }

    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        return this.getTransformation(null, asSeenBy);
    }

    public Vector3 getPosition(Vector3d offset, ReferenceFrame asSeenBy) {
        return this.getTransformation(asSeenBy).getPosition();
    }

    public Vector3 getPosition(ReferenceFrame asSeenBy) {
        return this.getPosition(null, asSeenBy);
    }

    public Matrix33 getAxes(ReferenceFrame asSeenBy) {
        return this.getTransformation(asSeenBy).getAxes();
    }

    public Vector3[] getOrientation(ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getAxes(asSeenBy);
        Vector3[] array = new Vector3[]{axes.getRow(2), axes.getRow(1)};
        return array;
    }

    public Quaternion getQuaternion(ReferenceFrame asSeenBy) {
        return this.getAxes(asSeenBy).getQuaternion();
    }

    public Vector4d transformTo(Vector4d xyzw, ReferenceFrame to) {
        return MathUtilities.multiply(xyzw, (Matrix4d)this.getTransformation(to));
    }

    public Vector3d transformTo(Vector3d xyz, ReferenceFrame to) {
        return new Vector3((Tuple4d)this.transformTo(new Vector4((Tuple3d)xyz, 1.0), to));
    }
}

