/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.VertexGeometry;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IndexedTriangleArray
extends VertexGeometry {
    public static final Property INDICES_PROPERTY = new Property(IndexedTriangleArray.class, "INDICES");
    public static final Property INDEX_LOWER_BOUND_PROPERTY = new Property(IndexedTriangleArray.class, "INDEX_LOWER_BOUND");
    public static final Property INDEX_UPPER_BOUND_PROPERTY = new Property(IndexedTriangleArray.class, "INDEX_UPPER_BOUND");
    private int[] m_indices = null;
    private int m_indexLowerBound = 0;
    private int m_indexUpperBound = -1;
    private int[] m_edges = null;
    private int m_subdivisionRefinementLevel = 0;

    public int[] getIndices() {
        return this.m_indices;
    }

    public void setIndices(int[] indices) {
        this.m_indices = indices;
        this.onPropertyChange(INDICES_PROPERTY);
    }

    public int getIndexLowerBound() {
        return this.m_indexLowerBound;
    }

    public void setIndexLowerBound(int indexLowerBound) {
        if (this.m_indexLowerBound != indexLowerBound) {
            this.m_indexLowerBound = indexLowerBound;
            this.onPropertyChange(INDEX_LOWER_BOUND_PROPERTY);
        }
    }

    public int getIndexUpperBound() {
        return this.m_indexUpperBound;
    }

    public void setIndexUpperBound(int indexUpperBound) {
        if (this.m_indexUpperBound != indexUpperBound) {
            this.m_indexUpperBound = indexUpperBound;
            this.onPropertyChange(INDEX_UPPER_BOUND_PROPERTY);
        }
    }

    public int getIndexCount() {
        if (this.m_indices != null) {
            return this.m_indices.length;
        }
        return 0;
    }

    public int getTriangleCount() {
        if (this.m_indices != null) {
            return this.m_indices.length / 3;
        }
        return 0;
    }

    public static void storeIndices(int[] indices, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(2);
        dos.writeInt(indices.length);
        int i = 0;
        while (i < indices.length) {
            dos.writeInt(indices[i]);
            ++i;
        }
        dos.flush();
    }

    public static int[] loadIndices(InputStream is) throws IOException {
        int[] indices = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        int version = dis.readInt();
        if (version == 1) {
            int faceCount = dis.readInt();
            int verticesPerFace = dis.readInt();
            indices = new int[faceCount * 3];
            int i = 0;
            while (i < indices.length) {
                indices[i] = dis.readInt();
                ++i;
            }
        } else if (version == 2) {
            int indicesCount = dis.readInt();
            indices = new int[indicesCount];
            int i = 0;
            while (i < indices.length) {
                indices[i] = dis.readInt();
                ++i;
            }
        } else {
            throw new RuntimeException(String.valueOf(Messages.getString("invalid_file_version__")) + version);
        }
        return indices;
    }
}

