/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Shape;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Sphere;

public class Cylinder
extends Shape {
    public static final Property BASE_RADIUS_PROPERTY = new Property(Cylinder.class, "BASE_RADIUS");
    public static final Property TOP_RADIUS_PROPERTY = new Property(Cylinder.class, "TOP_RADIUS");
    public static final Property HEIGHT_PROPERTY = new Property(Cylinder.class, "HEIGHT");
    private double m_baseRadius = 1.0;
    private double m_topRadius = 1.0;
    private double m_height = 1.0;

    public double getBaseRadius() {
        return this.m_baseRadius;
    }

    public void setBaseRadius(double baseRadius) {
        if (this.m_baseRadius != baseRadius) {
            this.m_baseRadius = baseRadius;
            this.onPropertyChange(BASE_RADIUS_PROPERTY);
            this.onBoundsChange();
        }
    }

    public double getTopRadius() {
        return this.m_topRadius;
    }

    public void setTopRadius(double topRadius) {
        if (this.m_topRadius != topRadius) {
            this.m_topRadius = topRadius;
            this.onPropertyChange(TOP_RADIUS_PROPERTY);
            this.onBoundsChange();
        }
    }

    public double getHeight() {
        return this.m_height;
    }

    public void setHeight(double height) {
        if (this.m_height != height) {
            this.m_height = height;
            this.onPropertyChange(HEIGHT_PROPERTY);
            this.onBoundsChange();
        }
    }

    @Override
    protected void updateBoundingBox() {
        double radius = Math.max(this.m_baseRadius, this.m_topRadius);
        this.m_boundingBox = new Box(-radius, 0.0, -radius, radius, this.m_height, radius);
    }

    @Override
    protected void updateBoundingSphere() {
        double halfHeight = this.m_height * 0.5;
        double radius = Math.max(halfHeight, Math.max(this.m_baseRadius, this.m_topRadius));
        this.m_boundingSphere = new Sphere(0.0, halfHeight, 0.0, radius);
    }
}

