/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.ChildrenListener;
import edu.cmu.cs.stage3.lang.Messages;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Container
extends Component {
    private Vector m_children = new Vector();
    private Component[] m_childArray = null;
    private Vector m_childrenListeners = new Vector();
    private ChildrenListener[] m_childrenListenerArray = null;

    public boolean isAncestorOf(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDescendantOf(this);
    }

    @Override
    protected void releasePass1() {
        Component[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Container.warnln(String.valueOf(Messages.getString("WARNING__released_container_")) + this + " " + Messages.getString("still_has_child_") + children[i] + ".");
            children[i].setParent(null);
            ++i;
        }
        super.releasePass1();
    }

    @Override
    protected void releasePass2() {
        this.m_children = null;
        this.m_childArray = null;
        super.releasePass2();
    }

    @Override
    protected void releasePass3() {
        Enumeration enum0 = this.m_childrenListeners.elements();
        while (enum0.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enum0.nextElement();
            Container.warnln(String.valueOf(Messages.getString("WARNING__released_container_")) + this + " " + Messages.getString("still_has_childrenListener_") + childrenListener + ".");
        }
        this.m_childrenListeners = null;
        this.m_childrenListenerArray = null;
        super.releasePass3();
    }

    protected void onAddChild(Component child) {
        if (this.isReleased()) {
            Container.warnln(String.valueOf(Messages.getString("WARNING__scenegraph_addChild_")) + child + " " + Messages.getString("on_already_released_") + this + ".");
        } else if (child.isReleased()) {
            Container.warnln(String.valueOf(Messages.getString("WARNING__scenegraph_addChild_from_")) + this + " " + Messages.getString("on_already_released_child_") + child + ".");
        } else {
            this.m_children.addElement(child);
            this.m_childArray = null;
            ChildrenEvent childrenEvent = new ChildrenEvent(this, 1, child);
            ChildrenListener[] childrenListeners = this.getChildrenListeners();
            int i = 0;
            while (i < childrenListeners.length) {
                childrenListeners[i].childAdded(childrenEvent);
                ++i;
            }
        }
    }

    protected void onRemoveChild(Component child) {
        if (this.isReleased()) {
            Container.warnln(String.valueOf(Messages.getString("WARNING__scenegraph_removeChild_")) + child + " " + Messages.getString("on_already_released_") + this + ".");
        } else if (child.isReleased()) {
            Container.warnln(String.valueOf(Messages.getString("WARNING__scenegraph_removeChild_from_")) + this + " " + Messages.getString("on_already_released_child_") + child + ".");
        } else {
            this.m_children.removeElement(child);
            this.m_childArray = null;
            ChildrenEvent childrenEvent = new ChildrenEvent(this, 2, child);
            ChildrenListener[] childrenListeners = this.getChildrenListeners();
            int i = 0;
            while (i < childrenListeners.length) {
                childrenListeners[i].childRemoved(childrenEvent);
                ++i;
            }
        }
    }

    public Component[] getChildren() {
        if (this.m_childArray == null) {
            this.m_childArray = new Component[this.m_children.size()];
            this.m_children.copyInto(this.m_childArray);
        }
        return this.m_childArray;
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public Component getChildAt(int i) {
        return (Component)this.m_children.elementAt(i);
    }

    public void addChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.addElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public void removeChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.removeElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public ChildrenListener[] getChildrenListeners() {
        if (this.m_childrenListenerArray == null) {
            this.m_childrenListenerArray = new ChildrenListener[this.m_childrenListeners.size()];
            this.m_childrenListeners.copyInto(this.m_childrenListenerArray);
        }
        return this.m_childrenListenerArray;
    }

    @Override
    protected void onAbsoluteTransformationChange() {
        super.onAbsoluteTransformationChange();
        Component[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].onAbsoluteTransformationChange();
            ++i;
        }
    }

    @Override
    protected void onHierarchyChange() {
        super.onHierarchyChange();
        Component[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].onHierarchyChange();
            ++i;
        }
    }
}

