/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.math.Interpolable;
import java.io.Serializable;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;

public class Color
implements Cloneable,
Serializable,
Interpolable {
    public static final Color RED = new Color(java.awt.Color.red);
    public static final Color PINK = new Color(java.awt.Color.pink);
    public static final Color ORANGE = new Color(new java.awt.Color(255, 165, 0));
    public static final Color YELLOW = new Color(java.awt.Color.yellow);
    public static final Color GREEN = new Color(java.awt.Color.green);
    public static final Color BLUE = new Color(java.awt.Color.blue);
    public static final Color PURPLE = new Color(new java.awt.Color(128, 0, 128));
    public static final Color BROWN = new Color(new java.awt.Color(162, 42, 42));
    public static final Color WHITE = new Color(java.awt.Color.white);
    public static final Color LIGHT_GRAY = new Color(java.awt.Color.lightGray);
    public static final Color GRAY = new Color(java.awt.Color.gray);
    public static final Color DARK_GRAY = new Color(java.awt.Color.darkGray);
    public static final Color BLACK = new Color(java.awt.Color.black);
    public static final Color CYAN = new Color(java.awt.Color.cyan);
    public static final Color MAGENTA = new Color(java.awt.Color.magenta);
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public Color() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Color(float[] array) {
        this.alpha = 1.0f;
        switch (array.length) {
            case 4: {
                this.alpha = array[3];
            }
            case 3: {
                this.blue = array[2];
                this.green = array[1];
                this.red = array[0];
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public Color(double red, double green, double blue) {
        this((float)red, (float)green, (float)blue);
    }

    public Color(double red, double green, double blue, double alpha) {
        this((float)red, (float)green, (float)blue, (float)alpha);
    }

    public Color(double[] array) {
        this.alpha = 1.0f;
        switch (array.length) {
            case 4: {
                this.alpha = (float)array[3];
            }
            case 3: {
                this.blue = (float)array[2];
                this.green = (float)array[1];
                this.red = (float)array[0];
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public Color(Color color) {
        this(color.red, color.green, color.blue, color.alpha);
    }

    public Color(Color3f color) {
        this(color.x, color.y, color.z);
    }

    public Color(Color4f color) {
        this(color.x, color.y, color.z, color.w);
    }

    public Color(java.awt.Color color) {
        this((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Color) {
            Color c = (Color)o;
            return this.red == c.red && this.green == c.green && this.blue == c.blue && this.alpha == c.alpha;
        }
        return false;
    }

    public java.awt.Color createAWTColor() {
        float r = (float)Math.max(Math.min((double)this.red, 1.0), 0.0);
        float g = (float)Math.max(Math.min((double)this.green, 1.0), 0.0);
        float b = (float)Math.max(Math.min((double)this.blue, 1.0), 0.0);
        return new java.awt.Color(r, g, b);
    }

    public Color3f createVecmathColor3f() {
        return new Color3f(this.red, this.green, this.blue);
    }

    public Color4f createVecmathColor4f() {
        return new Color4f(this.red, this.green, this.blue, this.alpha);
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static Color interpolate(Color a, Color b, double portion) {
        return new Color(a.red + (b.red - a.red) * (float)portion, a.green + (b.green - a.green) * (float)portion, a.blue + (b.blue - a.blue) * (float)portion, a.alpha + (b.alpha - a.alpha) * (float)portion);
    }

    @Override
    public Interpolable interpolate(Interpolable b, double portion) {
        return Color.interpolate(this, (Color)b, portion);
    }

    public String toString() {
        return "edu.cmu.cs.stage3.alice.scenegraph.Color[r=" + this.red + ",g=" + this.green + ",b=" + this.blue + ",a=" + this.alpha + "]";
    }

    public static Color valueOf(String s) {
        if (s == null) {
            s = "edu.cmu.cs.stage3.alice.scenegraph.Color[r=0.0,g=0.30588236,b=0.59607846,a=1.0]";
        }
        String[] markers = new String[]{"edu.cmu.cs.stage3.alice.scenegraph.Color[r=", ",g=", ",b=", ",a=", "]"};
        float[] values = new float[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Float.valueOf(s.substring(begin, end)).floatValue();
            ++i;
        }
        return new Color(values);
    }
}

