/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.lang.Messages;
import javax.vecmath.Matrix4d;

public abstract class Camera
extends Component {
    public static final Property NEAR_CLIPPING_PLANE_DISTANCE_PROPERTY = new Property(Camera.class, "NEAR_CLIPPING_PLANE_DISTANCE");
    public static final Property FAR_CLIPPING_PLANE_DISTANCE_PROPERTY = new Property(Camera.class, "FAR_CLIPPING_PLANE_DISTANCE");
    public static final Property BACKGROUND_PROPERTY = new Property(Camera.class, "BACKGROUND");
    private double m_nearClippingPlaneDistance = 0.125;
    private double m_farClippingPlaneDistance = 256.0;
    private Background m_background = null;

    @Override
    protected void releasePass1() {
        if (this.m_background != null) {
            Camera.warnln(String.valueOf(Messages.getString("WARNING__released_camera_")) + this + " " + Messages.getString("still_has_background_") + this.m_background + ".");
            this.setBackground(null);
        }
        super.releasePass1();
    }

    public double getNearClippingPlaneDistance() {
        return this.m_nearClippingPlaneDistance;
    }

    public void setNearClippingPlaneDistance(double nearClippingPlaneDistance) {
        if (this.m_nearClippingPlaneDistance != nearClippingPlaneDistance) {
            this.m_nearClippingPlaneDistance = nearClippingPlaneDistance;
            this.onPropertyChange(NEAR_CLIPPING_PLANE_DISTANCE_PROPERTY);
        }
    }

    public double getFarClippingPlaneDistance() {
        return this.m_farClippingPlaneDistance;
    }

    public void setFarClippingPlaneDistance(double farClippingPlaneDistance) {
        if (this.m_farClippingPlaneDistance != farClippingPlaneDistance) {
            this.m_farClippingPlaneDistance = farClippingPlaneDistance;
            this.onPropertyChange(FAR_CLIPPING_PLANE_DISTANCE_PROPERTY);
        }
    }

    public Background getBackground() {
        return this.m_background;
    }

    public void setBackground(Background background) {
        if (this.m_background != background) {
            this.m_background = background;
            this.onPropertyChange(BACKGROUND_PROPERTY);
        }
    }

    public abstract Matrix4d getProjection();
}

