/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.player;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.clock.DefaultClock;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DefaultRenderTargetFactory;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import edu.cmu.cs.stage3.io.ZipTreeLoader;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.scheduler.AbstractScheduler;
import edu.cmu.cs.stage3.scheduler.SchedulerThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class AbstractPlayer {
    private DefaultRenderTargetFactory m_drtf;
    private DefaultClock m_clock = new DefaultClock();
    private long m_when0 = System.currentTimeMillis();
    private World m_world = null;
    private boolean m_isGoodToSchedule = false;

    public AbstractPlayer(Class rendererClass) {
        this.m_drtf = new DefaultRenderTargetFactory(rendererClass);
        AbstractScheduler scheduler = new AbstractScheduler(){

            @Override
            protected void handleCaughtThowable(Runnable source, Throwable t) {
                this.markEachFrameRunnableForRemoval(source);
                t.printStackTrace();
            }
        };
        scheduler.addEachFrameRunnable(new Runnable(){

            @Override
            public void run() {
                AbstractPlayer.this.schedule();
            }
        });
        SchedulerThread schedulerThread = new SchedulerThread(scheduler);
        schedulerThread.start();
    }

    public AbstractPlayer() {
        this(null);
    }

    protected Clock newClock() {
        return new DefaultClock();
    }

    protected abstract void handleRenderTarget(RenderTarget var1);

    protected abstract boolean isPreserveAndRestoreRequired();

    /*
     * Unable to fully structure code
     */
    public void loadWorld(DirectoryTreeLoader loader, ProgressObserver progressObserver) throws IOException {
        block5: {
            try {
                this.m_world = (World)Element.load(loader, null, progressObserver);
                this.m_world.setRenderTargetFactory(this.m_drtf);
                this.m_world.setClock(this.m_clock);
                this.m_clock.setWorld(this.m_world);
                renderTargets = (RenderTarget[])this.m_world.getDescendants(RenderTarget.class);
                i = 0;
                while (i < renderTargets.length) {
                    this.handleRenderTarget(renderTargets[i]);
                    ++i;
                }
                break block5;
            }
            catch (ProgressCancelException pce) {
                throw new ExceptionWrapper(pce, loader.toString());
            }
            catch (UnresolvablePropertyReferencesException upre) {
                propertyReferences = upre.getPropertyReferences();
                System.err.println("could not load: " + loader + ".  was unable to resolve the following references.");
                i = 0;
                ** while (i < propertyReferences.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println("\t" + propertyReferences[i]);
                ++i;
                continue;
            }
        }
    }

    public void loadWorld(InputStream ios, ProgressObserver progressObserver) throws IOException {
        ZipTreeLoader loader = new ZipTreeLoader();
        loader.open(ios);
        this.loadWorld(loader, progressObserver);
    }

    public void loadWorld(URL url, ProgressObserver progressObserver) throws IOException {
        ZipTreeLoader loader = new ZipTreeLoader();
        loader.open(url);
        this.loadWorld(loader, progressObserver);
    }

    public void loadWorld(File file, ProgressObserver progressObserver) throws IOException {
        ZipFileTreeLoader loader = new ZipFileTreeLoader();
        loader.open(file);
        this.loadWorld(loader, progressObserver);
    }

    public void unloadWorld() {
        if (this.m_world != null) {
            this.stopWorldIfNecessary();
            this.m_world.release();
            this.m_world = null;
        }
    }

    public void startWorld() {
        if (this.isPreserveAndRestoreRequired()) {
            this.m_world.preserve();
        }
        this.m_clock.start();
        this.m_isGoodToSchedule = true;
    }

    public void pauseWorld() {
        this.m_clock.pause();
    }

    public void resumeWorld() {
        this.m_clock.resume();
    }

    public void stopWorld() {
        this.m_isGoodToSchedule = false;
        this.m_clock.stop();
        if (this.isPreserveAndRestoreRequired()) {
            this.m_world.restore();
        }
    }

    public void stopWorldIfNecessary() {
        if (this.m_world != null && this.m_world.isRunning()) {
            this.stopWorld();
        }
    }

    private double getTime() {
        return (double)(System.currentTimeMillis() - this.m_when0) * 0.001;
    }

    public void schedule() {
        if (this.m_isGoodToSchedule) {
            this.m_clock.schedule();
        }
    }

    public void setSpeed(double speed) {
        this.m_clock.setSpeed(speed);
    }
}

