/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.gallery.modeleditor;

import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.Sound;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.light.AmbientLight;
import edu.cmu.cs.stage3.alice.core.light.DirectionalLight;
import edu.cmu.cs.stage3.alice.core.light.PointLight;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.ImageIcon;

class IconManager {
    private static Dictionary s_classToImageMap = new Hashtable();
    private static ImageIcon m_defaultIcon = IconManager.loadImageFromResource("images/default.gif");
    private static ImageIcon m_modelIcon = IconManager.loadImageFromResource("images/model.png");
    private static ImageIcon m_partIcon = IconManager.loadImageFromResource("images/subpart.gif");
    private static ImageIcon m_methodIcon = IconManager.loadImageFromResource("images/method.png");
    private static ImageIcon m_questionIcon = IconManager.loadImageFromResource("images/question.png");
    private static ImageIcon m_propertyIcon = IconManager.loadImageFromResource("images/property.png");

    static {
        s_classToImageMap.put(AmbientLight.class, IconManager.loadImageFromResource("images/ambientLight.gif"));
        s_classToImageMap.put(DirectionalLight.class, IconManager.loadImageFromResource("images/directionalLight.gif"));
        s_classToImageMap.put(PointLight.class, IconManager.loadImageFromResource("images/pointLight.png"));
        s_classToImageMap.put(SymmetricPerspectiveCamera.class, IconManager.loadImageFromResource("images/camera.png"));
        s_classToImageMap.put(TextureMap.class, IconManager.loadImageFromResource("images/types/edu.cmu.cs.stage3.alice.core.TextureMap.gif"));
        s_classToImageMap.put(Sound.class, IconManager.loadImageFromResource("images/types/edu.cmu.cs.stage3.alice.core.Sound.gif"));
        s_classToImageMap.put(Pose.class, IconManager.loadImageFromResource("images/types/edu.cmu.cs.stage3.alice.core.Pose.gif"));
    }

    IconManager() {
    }

    private static ImageIcon loadImageFromResource(String name) {
        URL resource = JAlice.class.getResource(name);
        return new ImageIcon(resource);
    }

    public static ImageIcon lookupIcon(Object o) {
        ImageIcon icon = (ImageIcon)s_classToImageMap.get(o.getClass());
        if (icon == null) {
            if (o instanceof Model) {
                Model model = (Model)o;
                if (model.isFirstClass.booleanValue()) {
                    return m_modelIcon;
                }
                return m_partIcon;
            }
            if (o instanceof UserDefinedResponse) {
                return m_methodIcon;
            }
            if (o instanceof UserDefinedQuestion) {
                return m_methodIcon;
            }
            if (o instanceof Variable) {
                return m_propertyIcon;
            }
            return m_defaultIcon;
        }
        return icon;
    }
}

