/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.gallery;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Light;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class CaitlinFixer {
    private static World m_world = null;

    private static void clear(ElementArrayProperty eap) {
        while (eap.size() > 0) {
            Element element = (Element)eap.get(0);
            element.HACK_removeFromParentWithoutCheckingForExternalReferences();
        }
        eap.clear();
    }

    private static void removeAllMarkersAndLights(Element element) {
        Vector<Element> v = new Vector<Element>();
        int i = 0;
        while (i < element.getChildCount()) {
            Element child = element.getChildAt(i);
            if (child instanceof Light) {
                v.addElement(child);
            } else {
                String allLowercaseName = child.name.getStringValue().toLowerCase();
                if (allLowercaseName.indexOf("marker") != -1 || allLowercaseName.equals("chase") || allLowercaseName.equals("whole") || allLowercaseName.equals("closeup") || allLowercaseName.equals("close up") || allLowercaseName.equals("far") || allLowercaseName.equals("revolve")) {
                    v.addElement(child);
                }
            }
            ++i;
        }
        i = 0;
        while (i < v.size()) {
            Element elementsToRemoveI = (Element)v.elementAt(i);
            System.err.println("removing: " + elementsToRemoveI);
            elementsToRemoveI.removeFromParent();
            ++i;
        }
    }

    private static void removeMethodsFromObject(File srcRoot, File dstRoot, File srcFile) {
        try {
            File dstFile = new File(String.valueOf(dstRoot.getAbsolutePath()) + srcFile.getAbsolutePath().substring(srcRoot.getAbsolutePath().length()));
            System.err.println(dstFile);
            dstFile.getParentFile().mkdirs();
            if (!dstFile.exists()) {
                Element e = Element.load(srcFile, (Element)m_world, null);
                e.setParent(m_world);
                if (e instanceof Sandbox) {
                    Sandbox sandbox = (Sandbox)e;
                    CaitlinFixer.clear(sandbox.variables);
                    CaitlinFixer.clear(sandbox.responses);
                    CaitlinFixer.clear(sandbox.questions);
                    CaitlinFixer.clear(sandbox.behaviors);
                    CaitlinFixer.clear(sandbox.sounds);
                }
                Model[] models = (Model[])e.getDescendants(Model.class);
                int i = 0;
                while (i < models.length) {
                    CaitlinFixer.clear(models[i].poses);
                    ++i;
                }
                CaitlinFixer.removeAllMarkersAndLights(e);
                Hashtable<String, byte[]> map = new Hashtable<String, byte[]>();
                String srcPath = srcFile.getAbsolutePath();
                File thumbnailFile = new File(String.valueOf(srcPath.substring(0, srcPath.length() - 3)) + "png");
                if (thumbnailFile.exists()) {
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(thumbnailFile));
                    int n = bis.available();
                    byte[] data = new byte[n];
                    if (bis.read(data, 0, n) == n) {
                        ((Dictionary)map).put("thumbnail.png", data);
                    } else {
                        System.err.println("did not read entire thumbnail: " + thumbnailFile);
                    }
                }
                e.store(dstFile, null, map);
                e.store(dstFile);
                e.removeFromParent();
                e.release();
                e = null;
            }
        }
        catch (Throwable t) {
            System.err.println(srcFile);
            t.printStackTrace();
            System.exit(-1);
        }
    }

    private static void removeMethodsFromObjectsInDirectory(File srcRoot, File dstRoot, File srcDir) {
        System.err.println("removeMethodsFromObjectsInDirectory: " + srcDir);
        File[] directories = srcDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int i = 0;
        while (i < directories.length) {
            CaitlinFixer.removeMethodsFromObjectsInDirectory(srcRoot, dstRoot, directories[i]);
            ++i;
        }
        File[] files = srcDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".a2c");
            }
        });
        int i2 = 0;
        while (i2 < files.length) {
            CaitlinFixer.removeMethodsFromObject(srcRoot, dstRoot, files[i2]);
            ++i2;
        }
    }
}

