/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;

public abstract class WorldListener {
    private World m_world;
    private ChildrenListener m_childrenListener = new ChildrenListener(){

        @Override
        public void childrenChanging(ChildrenEvent e) {
            WorldListener.this.handleChildrenChanging(e);
        }

        @Override
        public void childrenChanged(ChildrenEvent e) {
            if (e.getChangeType() == 1) {
                WorldListener.this.hookUp(e.getChild());
            } else if (e.getChangeType() == 3) {
                WorldListener.this.unhookUp(e.getChild());
            }
            WorldListener.this.handleChildrenChanged(e);
        }
    };
    private PropertyListener m_propertyListener = new PropertyListener(){

        @Override
        public void propertyChanging(PropertyEvent e) {
            WorldListener.this.handlePropertyChanging(e);
        }

        @Override
        public void propertyChanged(PropertyEvent e) {
            WorldListener.this.handlePropertyChanged(e);
        }
    };
    private ObjectArrayPropertyListener m_objectArrayPropertyListener = new ObjectArrayPropertyListener(){

        @Override
        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent e) {
            WorldListener.this.handleObjectArrayPropertyChanging(e);
        }

        @Override
        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent e) {
            WorldListener.this.handleObjectArrayPropertyChanged(e);
        }
    };

    protected abstract void handleChildrenChanging(ChildrenEvent var1);

    protected abstract void handleChildrenChanged(ChildrenEvent var1);

    protected abstract void handlePropertyChanging(PropertyEvent var1);

    protected abstract void handlePropertyChanged(PropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanging(ObjectArrayPropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanged(ObjectArrayPropertyEvent var1);

    protected abstract boolean isPropertyListeningRequired(Property var1);

    protected abstract boolean isObjectArrayPropertyListeningRequired(ObjectArrayProperty var1);

    public World getWorld() {
        return this.m_world;
    }

    public void setWorld(World world) {
        if (this.m_world != world) {
            if (this.m_world != null) {
                this.unhookUp(this.m_world);
            }
            this.m_world = world;
            if (this.m_world != null) {
                this.hookUp(this.m_world);
            }
        }
    }

    private boolean isChildrenListenerHookedUp(Element element) {
        ChildrenListener[] childrenListeners = element.getChildrenListeners();
        int i = 0;
        while (i < childrenListeners.length) {
            if (childrenListeners[i] == this.m_childrenListener) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isPropertyListenerHookedUp(Property property) {
        PropertyListener[] propertyListeners = property.getPropertyListeners();
        int i = 0;
        while (i < propertyListeners.length) {
            if (propertyListeners[i] == this.m_propertyListener) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isObjectArrayPropertyListenerHookedUp(ObjectArrayProperty oap) {
        ObjectArrayPropertyListener[] oapListeners = oap.getObjectArrayPropertyListeners();
        int i = 0;
        while (i < oapListeners.length) {
            if (oapListeners[i] == this.m_objectArrayPropertyListener) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void unhookUp(Element element) {
        if (this.isChildrenListenerHookedUp(element)) {
            element.removeChildrenListener(this.m_childrenListener);
        }
        Property[] properties = element.getProperties();
        int i = 0;
        while (i < properties.length) {
            ObjectArrayProperty oapI;
            Property propertyI = properties[i];
            if (this.isPropertyListeningRequired(propertyI) && this.isPropertyListenerHookedUp(propertyI)) {
                propertyI.removePropertyListener(this.m_propertyListener);
            }
            if (propertyI instanceof ObjectArrayProperty && this.isObjectArrayPropertyListeningRequired(oapI = (ObjectArrayProperty)propertyI) && this.isObjectArrayPropertyListenerHookedUp(oapI)) {
                oapI.removeObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
            }
            ++i;
        }
        Element[] children = element.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.unhookUp(children[i2]);
            ++i2;
        }
    }

    private void hookUp(Element element) {
        if (!this.isChildrenListenerHookedUp(element)) {
            element.addChildrenListener(this.m_childrenListener);
        }
        Property[] properties = element.getProperties();
        int i = 0;
        while (i < properties.length) {
            ObjectArrayProperty oapI;
            Property propertyI = properties[i];
            if (this.isPropertyListeningRequired(propertyI) && !this.isPropertyListenerHookedUp(propertyI)) {
                propertyI.addPropertyListener(this.m_propertyListener);
            }
            if (propertyI instanceof ObjectArrayProperty && this.isObjectArrayPropertyListeningRequired(oapI = (ObjectArrayProperty)propertyI) && !this.isObjectArrayPropertyListenerHookedUp(oapI)) {
                oapI.addObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
            }
            ++i;
        }
        Element[] children = element.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            this.hookUp(children[i2]);
            ++i2;
        }
    }
}

