/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.image.ImageUtilities;
import edu.cmu.cs.stage3.util.VisitListener;
import java.awt.Image;

public class TextureMapCounter
implements VisitListener {
    int m_textureMapCount = 0;
    int m_textureMapMemoryCount = 0;

    @Override
    public void visited(Object o) {
        if (o instanceof TextureMap) {
            TextureMap textureMap = (TextureMap)o;
            ++this.m_textureMapCount;
            Image image = textureMap.image.getImageValue();
            try {
                int width = ImageUtilities.getWidth(image);
                int height = ImageUtilities.getHeight(image);
                int depth = 4;
                if (width != -1 || height != -1) {
                    this.m_textureMapMemoryCount += width * height * depth;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getTextureMapCount() {
        return this.m_textureMapCount;
    }

    public int getTextureMapMemoryCount() {
        return this.m_textureMapMemoryCount;
    }
}

