/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Light;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.alice.core.camera.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.light.DirectionalLight;
import edu.cmu.cs.stage3.alice.scenegraph.AmbientLight;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Background;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.PointLight;
import edu.cmu.cs.stage3.alice.scenegraph.ProjectionCamera;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.SpotLight;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;

public class ScenegraphConverter {
    private static Component getFirstChildOfClass(Container sgContainer, Class cls) {
        int i = 0;
        while (i < sgContainer.getChildCount()) {
            Component sgChild = sgContainer.getChildAt(i);
            if (cls.isAssignableFrom(sgChild.getClass())) {
                return sgChild;
            }
            ++i;
        }
        return null;
    }

    private static edu.cmu.cs.stage3.alice.scenegraph.Light getFirstLightChild(Container sgContainer) {
        return (edu.cmu.cs.stage3.alice.scenegraph.Light)ScenegraphConverter.getFirstChildOfClass(sgContainer, edu.cmu.cs.stage3.alice.scenegraph.Light.class);
    }

    private static AmbientLight getFirstAmbientLightChild(Container sgContainer) {
        return (AmbientLight)ScenegraphConverter.getFirstChildOfClass(sgContainer, AmbientLight.class);
    }

    private static edu.cmu.cs.stage3.alice.scenegraph.Camera getFirstCameraChild(Container sgContainer) {
        return (edu.cmu.cs.stage3.alice.scenegraph.Camera)ScenegraphConverter.getFirstChildOfClass(sgContainer, edu.cmu.cs.stage3.alice.scenegraph.Camera.class);
    }

    private static Visual getFirstVisualChild(Container sgContainer) {
        return (Visual)ScenegraphConverter.getFirstChildOfClass(sgContainer, Visual.class);
    }

    private static Element internalConvert(Container sgContainer, int id) {
        ReferenceFrame element = null;
        if (sgContainer instanceof Scene) {
            Scene sgScene = (Scene)sgContainer;
            AmbientLight sgAmbientLight = ScenegraphConverter.getFirstAmbientLightChild(sgScene);
            Background sgBackground = sgScene.getBackground();
            World world = new World();
            if (sgBackground != null) {
                world.atmosphereColor.set(sgBackground.getColor());
            }
            if (sgAmbientLight != null) {
                world.ambientLightColor.set(sgAmbientLight.getColor());
            }
            element = world;
        } else if (sgContainer instanceof Transformable) {
            Transformable sgTransformable = (Transformable)sgContainer;
            edu.cmu.cs.stage3.alice.scenegraph.Light sgLight = ScenegraphConverter.getFirstLightChild(sgTransformable);
            edu.cmu.cs.stage3.alice.scenegraph.Camera sgCamera = ScenegraphConverter.getFirstCameraChild(sgTransformable);
            Visual sgVisual = ScenegraphConverter.getFirstVisualChild(sgTransformable);
            Model model = null;
            if (sgLight != null) {
                Light light = null;
                if (sgLight instanceof AmbientLight) {
                    edu.cmu.cs.stage3.alice.core.light.AmbientLight ambientLight;
                    light = ambientLight = new edu.cmu.cs.stage3.alice.core.light.AmbientLight();
                } else if (sgLight instanceof edu.cmu.cs.stage3.alice.scenegraph.DirectionalLight) {
                    DirectionalLight directionalLight = new DirectionalLight();
                    light = directionalLight;
                } else if (sgLight instanceof PointLight) {
                    edu.cmu.cs.stage3.alice.core.light.PointLight pointLight = null;
                    if (sgLight instanceof SpotLight) {
                        edu.cmu.cs.stage3.alice.core.light.SpotLight spotLight = new edu.cmu.cs.stage3.alice.core.light.SpotLight();
                        pointLight = spotLight;
                    } else {
                        pointLight = new edu.cmu.cs.stage3.alice.core.light.PointLight();
                    }
                    light = pointLight;
                }
                model = light;
                sgLight.setBonus(model);
            } else if (sgCamera != null) {
                Camera camera = null;
                if (sgCamera instanceof edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera) {
                    SymmetricPerspectiveCamera symmetricPerspectiveCamera;
                    camera = symmetricPerspectiveCamera = new SymmetricPerspectiveCamera();
                } else if (sgCamera instanceof edu.cmu.cs.stage3.alice.scenegraph.PerspectiveCamera) {
                    PerspectiveCamera perspectiveCamera = new PerspectiveCamera();
                    camera = perspectiveCamera;
                } else if (sgCamera instanceof edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera) {
                    OrthographicCamera orthographicCamera = new OrthographicCamera();
                    camera = orthographicCamera;
                } else if (sgCamera instanceof ProjectionCamera) {
                    edu.cmu.cs.stage3.alice.core.camera.ProjectionCamera projectionCamera = new edu.cmu.cs.stage3.alice.core.camera.ProjectionCamera();
                    camera = projectionCamera;
                }
                model = camera;
                sgCamera.setBonus(model);
            } else {
                model = new Model();
            }
            if (sgVisual != null) {
                sgVisual.setBonus(model);
                Appearance sgAppearance = sgVisual.getFrontFacingAppearance();
                Geometry sgGeometry = sgVisual.getGeometry();
                if (sgAppearance != null) {
                    edu.cmu.cs.stage3.alice.scenegraph.TextureMap sgTextureMap = sgAppearance.getDiffuseColorMap();
                    if (sgTextureMap != null) {
                        TextureMap diffuseColorMap = new TextureMap();
                        diffuseColorMap.setParent(model);
                        diffuseColorMap.image.set(sgTextureMap.getImage());
                        diffuseColorMap.format.set(new Integer(sgTextureMap.getFormat()));
                        model.diffuseColorMap.set(diffuseColorMap);
                        model.textureMaps.add(diffuseColorMap);
                    }
                    model.color.set(sgAppearance.getDiffuseColor());
                    model.opacity.set(new Double(sgAppearance.getOpacity()));
                }
                if (sgGeometry instanceof IndexedTriangleArray) {
                    IndexedTriangleArray sgITA = (IndexedTriangleArray)sgGeometry;
                    edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray ita = new edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray();
                    ita.setParent(model);
                    ita.vertices.set(sgITA.getVertices());
                    ita.indices.set(sgITA.getIndices());
                    model.geometry.set(ita);
                    model.geometries.add(ita);
                }
            }
            model.setLocalTransformationRightNow(sgTransformable.getLocalTransformation());
            element = model;
        }
        int i = 0;
        while (i < sgContainer.getChildCount()) {
            Component sgChild = sgContainer.getChildAt(i);
            if (sgChild instanceof Transformable) {
                Model child = (Model)ScenegraphConverter.internalConvert((Transformable)sgChild, i);
                child.setParent(element);
                child.vehicle.set(element);
                if (child.name.getStringValue() == null) {
                    child.name.set("yet to be named part " + i);
                }
                if (element instanceof World) {
                    element.sandboxes.add(child);
                } else {
                    ((Model)element).parts.add(child);
                }
            }
            ++i;
        }
        String name = sgContainer.getName();
        if (name != null) {
            int i2 = name.indexOf(46);
            if (i2 != -1) {
                name = name.substring(0, i2);
            }
            element.name.set(name);
        }
        return element;
    }

    public static Element convert(Container sgContainer) {
        Element e = ScenegraphConverter.internalConvert(sgContainer, 0);
        if (e instanceof Model) {
            ((Model)e).isFirstClass.set(Boolean.TRUE);
        }
        if (e.name.getStringValue() == null) {
            e.name.set("yet to be named");
        }
        return e;
    }
}

