/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Geometry;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.util.VisitListener;

public class IndexedTriangleArrayCounter
implements VisitListener {
    private int m_indexedTriangleArrayCount = 0;
    private int m_shownIndexedTriangleArrayCount = 0;
    private int m_vertexCount = 0;
    private int m_shownVertexCount = 0;
    private int m_indexCount = 0;
    private int m_shownIndexCount = 0;

    @Override
    public void visited(Object o) {
        if (o instanceof IndexedTriangleArray) {
            IndexedTriangleArray ita = (IndexedTriangleArray)o;
            ++this.m_indexedTriangleArrayCount;
            this.m_vertexCount += ita.vertices.size();
            this.m_indexCount += ita.indices.size();
        } else if (o instanceof Model) {
            Geometry geometry;
            Model model = (Model)o;
            if (model.isShowing.booleanValue() && (geometry = model.geometry.getGeometryValue()) instanceof IndexedTriangleArray) {
                IndexedTriangleArray ita = (IndexedTriangleArray)geometry;
                ++this.m_shownIndexedTriangleArrayCount;
                this.m_shownVertexCount += ita.vertices.size();
                this.m_shownIndexCount += ita.indices.size();
            }
        }
    }

    public int getIndexedTriangleArrayCount() {
        return this.m_indexedTriangleArrayCount;
    }

    public int getShownIndexedTriangleArrayCount() {
        return this.m_shownIndexedTriangleArrayCount;
    }

    public int getVertexCount() {
        return this.m_vertexCount;
    }

    public int getShownVertexCount() {
        return this.m_shownVertexCount;
    }

    public int getIndexCount() {
        return this.m_indexCount;
    }

    public int getShownIndexCount() {
        return this.m_shownIndexCount;
    }
}

