/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.SpatialRelation;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.property.SpatialRelationProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractWalkAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.HermiteCubic;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;

public class WalkToAnimation
extends AbstractWalkAnimation {
    public final SpatialRelationProperty spatialRelation = new SpatialRelationProperty(this, "spatialRelation", SpatialRelation.IN_FRONT_OF);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(1.0));
    public final ReferenceFrameProperty asSeenBy = new ReferenceFrameProperty((Element)this, "target", null);

    public class RuntimeWalkToAnimation
    extends AbstractWalkAnimation.RuntimeAbstractWalkAnimation {
        private Box m_subjectBoundingBox;
        private Box m_asSeenByBoundingBox;
        protected ReferenceFrame m_asSeenBy;
        private Matrix44 m_transformationBegin;
        private Matrix44 m_transformationEnd;
        private HermiteCubic m_xHermite;
        private HermiteCubic m_yHermite;
        private HermiteCubic m_zHermite;
        private boolean m_affectPosition;
        private boolean m_affectQuaternion;
        private boolean beginEqualsEnd = false;
        double stepLength = -1.0;
        double numberOfSteps = -1.0;
        double currentPos = 0.0;
        double timePerStep = -1.0;
        private boolean done = false;

        protected Vector3d getPositionEnd() {
            if (this.m_subjectBoundingBox == null) {
                this.m_subjectBoundingBox = this.subject.getBoundingBox();
                if (this.m_subjectBoundingBox.getMaximum() == null) {
                    this.m_subjectBoundingBox = new Box(this.subject.getPosition(this.subject), this.subject.getPosition(this.subject));
                }
            }
            if (this.m_asSeenByBoundingBox == null) {
                this.m_asSeenByBoundingBox = this.m_asSeenBy.getBoundingBox();
                if (this.m_asSeenByBoundingBox.getMaximum() == null) {
                    this.m_asSeenByBoundingBox = new Box(this.m_asSeenBy.getPosition(this.m_asSeenBy), this.m_asSeenBy.getPosition(this.m_asSeenBy));
                }
            }
            SpatialRelation sv = WalkToAnimation.this.spatialRelation.getSpatialRelationValue();
            Vector3d v = sv.getPlaceVector(WalkToAnimation.this.amount.doubleValue(), this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
            return v;
        }

        protected double getValueAtTime(double t) {
            double ft = this.m_xHermite.evaluateDerivative(t);
            double ht = this.m_zHermite.evaluateDerivative(t);
            return Math.sqrt(ft * ft + ht * ht);
        }

        protected double getActualStepLength() {
            double distanceToMove = this.getPathLength();
            if (this.stepLength == -1.0) {
                this.stepLength = this.getStepLength();
                if (this.stepLength == 0.0) {
                    this.stepLength = 1.0;
                }
            }
            if (this.numberOfSteps == -1.0) {
                this.numberOfSteps = Math.round(distanceToMove / this.stepLength);
            }
            return distanceToMove / this.numberOfSteps;
        }

        @Override
        public double getTimeRemaining(double t) {
            double walkTime = WalkToAnimation.this.duration.doubleValue();
            if (Double.isNaN(walkTime)) {
                walkTime = this.numberOfSteps / WalkToAnimation.this.stepSpeed.doubleValue();
            }
            return walkTime - this.getTimeElapsed(t);
        }

        protected double getPathLength() {
            double h;
            double x1s = this.getValueAtTime(0.0) + this.getValueAtTime(1.0);
            double startT = h = 0.1;
            double x4s = 0.0;
            while (startT < 1.0) {
                x4s += this.getValueAtTime(startT);
                startT += 2.0 * h;
            }
            startT = 2.0 * h;
            double x2s = 0.0;
            while (startT < 1.0) {
                x2s += this.getValueAtTime(startT);
                startT += 2.0 * h;
            }
            return (x1s + 4.0 * x4s + 2.0 * x2s) * (h / 3.0);
        }

        @Override
        public void prologue(double t) {
            double distance;
            this.beginEqualsEnd = false;
            this.done = false;
            this.subject = WalkToAnimation.this.subject.getTransformableValue();
            this.m_asSeenBy = WalkToAnimation.this.asSeenBy.getReferenceFrameValue();
            Matrix44 asSeenByTrans = this.m_asSeenBy.getTransformation(this.subject.getWorld());
            ((Transformable)this.m_asSeenBy).standUpRightNow(this.subject.getWorld());
            this.m_transformationBegin = this.subject.getTransformation(this.m_asSeenBy);
            if (this.m_asSeenBy == null) {
                throw new SimulationPropertyException(String.valueOf(this.subject.name.getStringValue()) + " " + Messages.getString("needs_something_or_someone_to_walk_to_"), null, WalkToAnimation.this.asSeenBy);
            }
            if (this.subject == this.m_asSeenBy) {
                throw new SimulationPropertyException(String.valueOf(this.subject.name.getStringValue()) + " " + Messages.getString("can_t_walk_to_") + this.subject.name.getStringValue() + ".", this.getCurrentStack(), WalkToAnimation.this.asSeenBy);
            }
            if (this.subject.isAncestorOf(this.m_asSeenBy)) {
                throw new SimulationPropertyException(String.valueOf(this.subject.name.getStringValue()) + " " + Messages.getString("can_t_walk_to_a_part_of_itself"), this.getCurrentStack(), WalkToAnimation.this.asSeenBy);
            }
            Vector3d posAbs = this.getPositionEnd();
            Vector3 curPos = this.subject.getPosition();
            this.subject.setPositionRightNow(posAbs, this.m_asSeenBy);
            Matrix33 paMatrix = this.subject.calculatePointAt(this.m_asSeenBy, null, new Vector3d(0.0, 1.0, 0.0), this.m_asSeenBy, true);
            this.subject.setPositionRightNow(curPos);
            Matrix44 pov = WalkToAnimation.this.asSeenBy.getReferenceFrameValue().getPointOfView();
            pov.set(paMatrix);
            pov.setRow(3, posAbs.x, posAbs.y, posAbs.z, 1.0);
            this.m_transformationEnd = new Matrix44(pov);
            double dx = this.m_transformationBegin.m30 - this.m_transformationEnd.m30;
            double dy = this.m_transformationBegin.m31 - this.m_transformationEnd.m31;
            double dz = this.m_transformationBegin.m32 - this.m_transformationEnd.m32;
            double s = distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.m_xHermite = new HermiteCubic(this.m_transformationBegin.m30, this.m_transformationEnd.m30, this.m_transformationBegin.m20 * s, this.m_transformationEnd.m20 * s);
            this.m_yHermite = new HermiteCubic(this.m_transformationBegin.m31, this.m_transformationEnd.m31, this.m_transformationBegin.m21 * s, this.m_transformationEnd.m21 * s);
            this.m_zHermite = new HermiteCubic(this.m_transformationBegin.m32, this.m_transformationEnd.m32, this.m_transformationBegin.m22 * s, this.m_transformationEnd.m22 * s);
            super.prologue(t);
            this.getActualStepLength();
            ((Transformable)this.m_asSeenBy).setTransformationRightNow(asSeenByTrans, this.subject.getWorld());
        }

        @Override
        public void update(double t) {
            if (this.getTimeRemaining(t) > 0.0) {
                Matrix44 asSeenByTrans = this.m_asSeenBy.getTransformation(this.subject.getWorld());
                ((Transformable)this.m_asSeenBy).standUpRightNow(this.subject.getWorld());
                double portion = this.getTimeElapsed(t) / (this.getTimeElapsed(t) + this.getTimeRemaining(t));
                if (portion <= 1.0) {
                    double portionOfStep;
                    int stepNumber;
                    double x = this.m_xHermite.evaluate(portion);
                    double y = this.m_yHermite.evaluate(portion);
                    double z = this.m_zHermite.evaluate(portion);
                    this.subject.setPositionRightNow(x, y, z, this.m_asSeenBy);
                    double dx = this.m_xHermite.evaluateDerivative(portion);
                    double dy = 0.0;
                    double dz = this.m_zHermite.evaluateDerivative(portion);
                    if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
                        Matrix33 orient = new Matrix33();
                        orient.setForwardUpGuide(new Vector3d(dx, dy, dz), new Vector3d(0.0, 1.0, 0.0));
                        this.subject.setOrientationRightNow(orient, this.m_asSeenBy);
                    }
                    if (this.timePerStep == -1.0) {
                        this.timePerStep = !Double.isNaN(WalkToAnimation.this.duration.doubleValue()) ? WalkToAnimation.this.duration.doubleValue() / this.numberOfSteps : 1.0 / WalkToAnimation.this.stepSpeed.doubleValue();
                    }
                    if ((stepNumber = (int)Math.ceil(this.getTimeElapsed(t) * (1.0 / this.timePerStep)) - 1) == -1) {
                        stepNumber = 0;
                    }
                    if ((double)stepNumber == this.numberOfSteps) {
                        --stepNumber;
                    }
                    if ((portionOfStep = (this.getTimeElapsed(t) - (double)stepNumber * this.timePerStep) / this.timePerStep) > 1.0) {
                        portionOfStep = 1.0;
                    }
                    boolean lastStep = false;
                    if ((double)stepNumber == this.numberOfSteps - 1.0) {
                        lastStep = true;
                    }
                    if (stepNumber % 2 == 0) {
                        this.stepRight(portionOfStep, lastStep);
                    } else {
                        this.stepLeft(portionOfStep, lastStep);
                    }
                    super.update(t);
                }
                ((Transformable)this.m_asSeenBy).setTransformationRightNow(asSeenByTrans, this.subject.getWorld());
            }
        }
    }
}

