/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractWalkAnimation;
import edu.cmu.cs.stage3.alice.core.style.TraditionalAnimationStyle;

public class WalkAnimation
extends AbstractWalkAnimation {
    public final NumberProperty distance = new NumberProperty(this, "distance", new Double(1.0));

    public WalkAnimation() {
        this.style.set(TraditionalAnimationStyle.BEGIN_AND_END_ABRUPTLY);
    }

    @Override
    protected void propertyChanging(Property property, Object value) {
        if (property == this.distance) {
            if (value instanceof Number) {
                double d = ((Number)value).doubleValue();
            }
        } else {
            super.propertyChanging(property, value);
        }
    }

    public class RuntimeWalkAnimation
    extends AbstractWalkAnimation.RuntimeAbstractWalkAnimation {
        double currentPos = 0.0;
        double stepLength = -1.0;
        double numberOfSteps = -1.0;
        double timePerStep = -1.0;
        private boolean done = false;

        protected double getActualStepLength() {
            if (this.stepLength == -1.0) {
                this.stepLength = this.getStepLength();
                if (this.stepLength == 0.0) {
                    this.stepLength = 1.0;
                }
            }
            if (this.numberOfSteps == -1.0) {
                this.numberOfSteps = Math.round(WalkAnimation.this.distance.doubleValue() / this.stepLength);
            }
            return WalkAnimation.this.distance.doubleValue() / this.numberOfSteps;
        }

        protected double getTotalTime() {
            this.getActualStepLength();
            if (Double.isNaN(WalkAnimation.this.duration.doubleValue())) {
                return this.numberOfSteps / WalkAnimation.this.stepSpeed.doubleValue();
            }
            return WalkAnimation.this.duration.doubleValue();
        }

        @Override
        public double getTimeRemaining(double t) {
            return this.getTotalTime() - this.getTimeElapsed(t);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.currentPos = 0.0;
        }

        @Override
        public void update(double t) {
            if (this.getTimeRemaining(t) > 0.0) {
                double portionOfStep;
                int stepNumber;
                super.update(t);
                this.done = false;
                if (this.timePerStep == -1.0) {
                    this.timePerStep = !Double.isNaN(WalkAnimation.this.duration.doubleValue()) ? WalkAnimation.this.duration.doubleValue() / this.numberOfSteps : 1.0 / WalkAnimation.this.stepSpeed.doubleValue();
                }
                if ((stepNumber = (int)Math.ceil(this.getTimeElapsed(t) * (1.0 / this.timePerStep)) - 1) == -1) {
                    stepNumber = 0;
                }
                if ((double)stepNumber == this.numberOfSteps) {
                    --stepNumber;
                }
                if ((portionOfStep = (this.getTimeElapsed(t) - (double)stepNumber * this.timePerStep) / this.timePerStep) > 1.0) {
                    portionOfStep = 1.0;
                }
                boolean lastStep = false;
                if ((double)stepNumber == this.numberOfSteps - 1.0) {
                    lastStep = true;
                }
                if (stepNumber % 2 == 0) {
                    this.stepRight(portionOfStep, lastStep);
                } else {
                    this.stepLeft(portionOfStep, lastStep);
                }
                double portion = this.getTimeElapsed(t) / this.getTotalTime();
                double targetDistance = WalkAnimation.this.distance.doubleValue() * portion;
                if (targetDistance - this.currentPos > 0.0) {
                    WalkAnimation.this.subject.getTransformableValue().moveRightNow(Direction.FORWARD, targetDistance - this.currentPos);
                    this.currentPos += targetDistance - this.currentPos;
                    this.adjustHeight();
                }
            }
        }
    }
}

