/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.SpatialRelation;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.property.SpatialRelationProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractPositionAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;

public class TwoShotAnimation
extends AbstractPositionAnimation {
    public final SpatialRelationProperty spatialRelation = new SpatialRelationProperty(this, "spatialRelation", SpatialRelation.RIGHT_OF);
    public final ReferenceFrameProperty asSeenBy2 = new ReferenceFrameProperty((Element)this, "asSeenBy2", null);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(1.0));
    private double angleToRotate = 0.5235987755982988;
    protected ReferenceFrame m_asSeenBy2;

    public class RuntimeTwoShotAnimation
    extends AbstractPositionAnimation.RuntimeAbstractPositionAnimation {
        protected ReferenceFrame m_asSeenBy2;
        private Box m_subjectBoundingBox;
        private Box m_asSeenByBoundingBox;
        private Box m_asSeenBy2BoundingBox;
        private double m_amount;
        private Matrix33 m_cameraEndOrientation;
        private Matrix33 m_cameraBeginOrientation;
        private double m_cameraHeight;

        public RuntimeTwoShotAnimation() {
            super(TwoShotAnimation.this);
        }

        @Override
        public void prologue(double t) {
            this.m_asSeenBy = TwoShotAnimation.this.asSeenBy.getReferenceFrameValue();
            if (this.m_asSeenBy == null) {
                throw new SimulationPropertyException(Messages.getString("first_character_value_must_not_be_null_"), null, TwoShotAnimation.this.asSeenBy);
            }
            super.prologue(t);
            this.m_asSeenBy2 = TwoShotAnimation.this.asSeenBy2.getReferenceFrameValue();
            this.m_amount = TwoShotAnimation.this.amount.getNumberValue().doubleValue();
            if (this.m_asSeenBy2 == null) {
                throw new SimulationPropertyException(Messages.getString("second_character_value_must_not_be_null_"), this.getCurrentStack(), TwoShotAnimation.this.asSeenBy2);
            }
            if (this.m_subject == null) {
                throw new SimulationPropertyException(Messages.getString("subject_value_must_not_be_null_"), this.getCurrentStack(), TwoShotAnimation.this.subject);
            }
            if (this.m_asSeenBy2 == this.m_asSeenBy) {
                throw new SimulationPropertyException(Messages.getString("first_and_second_characters_must_be_different"), this.getCurrentStack(), TwoShotAnimation.this.asSeenBy2);
            }
            if (this.m_subject == this.m_asSeenBy || this.m_subject == this.m_asSeenBy2) {
                throw new SimulationPropertyException(Messages.getString("subject_value_cannot_be_the_same_as_either_character"), this.getCurrentStack(), TwoShotAnimation.this.subject);
            }
            if (this.m_amount < 0.0) {
                throw new SimulationPropertyException(Messages.getString("amount_must_be_greater_than_0"), this.getCurrentStack(), TwoShotAnimation.this.amount);
            }
            this.m_asSeenBy2.addAbsoluteTransformationListener(this);
        }

        protected Box getBoundingBox(ReferenceFrame ref, ReferenceFrame asSeenBy) {
            Box bbox = ref.getBoundingBox(asSeenBy);
            if (bbox.getMaximum() == null) {
                bbox = new Box(ref.getPosition(asSeenBy), ref.getPosition(asSeenBy));
            }
            return bbox;
        }

        protected double calculateB(double x0, double z0, double dx, double dz) {
            return z0 - dz / dx * x0;
        }

        protected double calculateXIntersect(double dxLeft, double dzLeft, double bLeft, double bForward) {
            return (bForward - bLeft) / (dzLeft / dxLeft + dxLeft / dzLeft);
        }

        protected double calculateZIntersect(double dxLeft, double dzLeft, double bLeft, double bForward) {
            return (dxLeft / dzLeft * bLeft + dzLeft / dxLeft * bForward) / (dxLeft / dzLeft + dzLeft / dxLeft);
        }

        protected double calculateDistance(double x1, double z1, double x2, double z2) {
            return Math.sqrt((x2 - x1) * (x2 - x1) + (z2 - z1) * (z2 - z1));
        }

        @Override
        protected Vector3d getPositionBegin() {
            this.m_cameraBeginOrientation = this.m_subject.getOrientationAsAxes(this.m_asSeenBy);
            return this.m_subject.getPosition(ReferenceFrame.ABSOLUTE);
        }

        @Override
        protected Vector3d getPositionEnd() {
            if (this.m_subjectBoundingBox == null) {
                this.m_subjectBoundingBox = this.getBoundingBox(this.m_subject, this.m_subject);
            }
            if (this.m_asSeenByBoundingBox == null) {
                this.m_asSeenByBoundingBox = this.getBoundingBox(this.m_asSeenBy, this.m_asSeenBy);
            }
            if (this.m_asSeenBy2BoundingBox == null) {
                this.m_asSeenBy2BoundingBox = this.getBoundingBox(this.m_asSeenBy2, this.m_asSeenBy);
            }
            this.m_asSeenByBoundingBox.union(this.m_asSeenBy2BoundingBox);
            SpatialRelation sv = TwoShotAnimation.this.spatialRelation.getSpatialRelationValue();
            Matrix33 cameraEndOrientation = this.m_asSeenBy.getOrientationAsAxes(this.m_asSeenBy);
            Vector3d cameraEndPos = new Vector3d();
            if (sv.equals(SpatialRelation.LEFT_OF)) {
                cameraEndPos = sv.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(1.0, 0.0, 0.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.RIGHT_OF)) {
                cameraEndPos = sv.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(-1.0, 0.0, 0.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.BEHIND_RIGHT_OF)) {
                cameraEndPos = SpatialRelation.BEHIND.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, 1.0), cameraEndOrientation.getRow(1));
                cameraEndOrientation.rotateY(-1.0 * TwoShotAnimation.this.angleToRotate);
            } else if (sv.equals(SpatialRelation.BEHIND_LEFT_OF)) {
                cameraEndPos = SpatialRelation.BEHIND.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, 1.0), cameraEndOrientation.getRow(1));
                cameraEndOrientation.rotateY(TwoShotAnimation.this.angleToRotate);
            } else if (sv.equals(SpatialRelation.FRONT_RIGHT_OF)) {
                cameraEndPos = SpatialRelation.IN_FRONT_OF.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, -1.0), cameraEndOrientation.getRow(1));
                cameraEndOrientation.rotateY(TwoShotAnimation.this.angleToRotate);
            } else if (sv.equals(SpatialRelation.FRONT_LEFT_OF)) {
                cameraEndPos = SpatialRelation.IN_FRONT_OF.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, -1.0), cameraEndOrientation.getRow(1));
                cameraEndOrientation.rotateY(-1.0 * TwoShotAnimation.this.angleToRotate);
            } else if (sv.equals(SpatialRelation.IN_FRONT_OF)) {
                cameraEndPos = sv.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, -1.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.BEHIND)) {
                cameraEndPos = sv.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, 1.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.ABOVE)) {
                cameraEndPos = sv.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, -1.0, 0.0), new Vector3d(-1.0, 0.0, 0.0));
            } else if (sv.equals(SpatialRelation.BELOW)) {
                cameraEndPos = sv.getPlaceVector(1.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 1.0, 0.0), new Vector3d(-1.0, 0.0, 0.0));
            }
            if (sv.equals(SpatialRelation.BEHIND_LEFT_OF) || sv.equals(SpatialRelation.BEHIND_RIGHT_OF) || sv.equals(SpatialRelation.FRONT_LEFT_OF) || sv.equals(SpatialRelation.FRONT_RIGHT_OF)) {
                Vector3 leftVector = cameraEndOrientation.getRow(0);
                Vector3 forwardVector = cameraEndOrientation.getRow(2);
                double bLeft = this.calculateB(cameraEndPos.x, cameraEndPos.z, leftVector.x, leftVector.z);
                Vector3d boxMin = this.m_asSeenByBoundingBox.getMinimum();
                double bForward = this.calculateB(boxMin.x, boxMin.z, forwardVector.x, forwardVector.z);
                double minX = this.calculateXIntersect(leftVector.x, leftVector.z, bLeft, bForward);
                double minZ = this.calculateZIntersect(leftVector.x, leftVector.z, bLeft, bForward);
                Vector3d boxMax = this.m_asSeenByBoundingBox.getMaximum();
                bForward = this.calculateB(boxMax.x, boxMax.z, forwardVector.x, forwardVector.z);
                double maxX = this.calculateXIntersect(leftVector.x, leftVector.z, bLeft, bForward);
                double maxZ = this.calculateZIntersect(leftVector.x, leftVector.z, bLeft, bForward);
                cameraEndPos.x = minX + (maxX - minX) / 2.0;
                cameraEndPos.z = minZ + (maxZ - minZ) / 2.0;
                double distance = this.calculateDistance(minX, minZ, maxX, maxZ);
                double largestDimSize = 0.0;
                largestDimSize = TwoShotAnimation.this.amount.doubleValue() * this.m_asSeenByBoundingBox.getHeight();
                if (distance > largestDimSize) {
                    largestDimSize = distance;
                }
                cameraEndPos.x += -2.5 * largestDimSize * forwardVector.x;
                cameraEndPos.z += -2.5 * largestDimSize * forwardVector.z;
                double halfViewable = this.m_asSeenByBoundingBox.getHeight() * TwoShotAnimation.this.amount.doubleValue() * 1.5 / 2.0;
                double startingHeight = (1.0 - TwoShotAnimation.this.amount.doubleValue()) * this.m_asSeenByBoundingBox.getHeight();
                cameraEndPos.y = this.m_cameraHeight = startingHeight + halfViewable + this.m_asSeenByBoundingBox.getMinimum().y;
            } else if (sv.equals(SpatialRelation.LEFT_OF) || sv.equals(SpatialRelation.RIGHT_OF)) {
                double largestDimSize = this.m_asSeenByBoundingBox.getDepth();
                if (TwoShotAnimation.this.amount.doubleValue() * this.m_asSeenByBoundingBox.getHeight() > largestDimSize) {
                    largestDimSize = TwoShotAnimation.this.amount.doubleValue() * this.m_asSeenByBoundingBox.getHeight();
                }
                cameraEndPos = sv.getPlaceVector(largestDimSize * 2.5, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                double halfViewable = this.m_asSeenByBoundingBox.getHeight() * TwoShotAnimation.this.amount.doubleValue() * 1.5 / 2.0;
                double startingHeight = (1.0 - TwoShotAnimation.this.amount.doubleValue()) * this.m_asSeenByBoundingBox.getHeight();
                cameraEndPos.y = this.m_cameraHeight = startingHeight + halfViewable + this.m_asSeenByBoundingBox.getMinimum().y;
                cameraEndPos.z = this.m_asSeenByBoundingBox.getCenter().z;
            } else if (sv.equals(SpatialRelation.IN_FRONT_OF) || sv.equals(SpatialRelation.BEHIND)) {
                double largestDimSize = this.m_asSeenByBoundingBox.getWidth();
                if (TwoShotAnimation.this.amount.doubleValue() * this.m_asSeenByBoundingBox.getHeight() > largestDimSize) {
                    largestDimSize = TwoShotAnimation.this.amount.doubleValue() * this.m_asSeenByBoundingBox.getHeight();
                }
                cameraEndPos = sv.getPlaceVector(largestDimSize * 3.0, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                double halfViewable = this.m_asSeenByBoundingBox.getHeight() * 1.5 * TwoShotAnimation.this.amount.doubleValue() / 2.0;
                double startingHeight = (1.0 - TwoShotAnimation.this.amount.doubleValue()) * this.m_asSeenByBoundingBox.getHeight();
                cameraEndPos.y = this.m_cameraHeight = startingHeight + halfViewable + this.m_asSeenByBoundingBox.getMinimum().y;
                cameraEndPos.x = this.m_asSeenByBoundingBox.getCenter().x;
            } else if (sv.equals(SpatialRelation.ABOVE) || sv.equals(SpatialRelation.BELOW)) {
                double largestDimSize = this.m_asSeenByBoundingBox.getDepth();
                if (this.m_asSeenByBoundingBox.getWidth() > largestDimSize) {
                    largestDimSize = this.m_asSeenByBoundingBox.getWidth();
                }
                cameraEndPos = sv.getPlaceVector(largestDimSize * 2.2, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
                double halfViewable = this.m_asSeenByBoundingBox.getDepth() / 2.0;
                cameraEndPos.z = this.m_cameraHeight = halfViewable + this.m_asSeenByBoundingBox.getMinimum().y;
                cameraEndPos.x = this.m_asSeenByBoundingBox.getCenter().x;
            }
            this.m_cameraEndOrientation = cameraEndOrientation;
            return this.m_asSeenBy.getPosition(cameraEndPos, ReferenceFrame.ABSOLUTE);
        }

        @Override
        public void update(double t) {
            super.update(t);
            Matrix33 nextOrient = Matrix33.interpolate(this.m_cameraBeginOrientation, this.m_cameraEndOrientation, this.getPortion(t));
            this.m_subject.setOrientationRightNow(nextOrient, this.m_asSeenBy);
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            if (this.m_asSeenBy2 != null) {
                this.m_asSeenBy2.removeAbsoluteTransformationListener(this);
            }
        }
    }
}

