/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.math.Matrix33;
import java.util.Vector;
import javax.vecmath.Vector3d;

public class StraightenAnimation
extends TransformAnimation {

    public class RuntimeStraightenAnimation
    extends TransformAnimation.RuntimeTransformAnimation {
        Vector bodyPartInitialOrientations = null;
        Vector bodyParts = null;
        Matrix33 normalOrientation = new Matrix33();

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.bodyPartInitialOrientations = new Vector();
            this.bodyParts = new Vector();
            this.normalOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0));
            if (this.m_subject != null) {
                if (!(this.m_subject.getParent() instanceof World)) {
                    this.addBodyPart(this.m_subject);
                }
                this.findChildren(this.m_subject);
            }
        }

        @Override
        public void update(double t) {
            int i = 0;
            while (i < this.bodyPartInitialOrientations.size()) {
                this.setOrientation((Transformable)this.bodyParts.elementAt(i), (Matrix33)this.bodyPartInitialOrientations.elementAt(i), this.normalOrientation, this.getPortion(t));
                ++i;
            }
            super.update(t);
        }

        private void findChildren(Transformable part) {
            Element[] kids = part.getChildren(Transformable.class);
            int i = 0;
            while (i < kids.length) {
                Transformable trans = (Transformable)kids[i];
                this.addBodyPart(trans);
                if (trans.getChildCount() > 0) {
                    this.findChildren(trans);
                }
                ++i;
            }
        }

        private void addBodyPart(Transformable partToAdd) {
            this.bodyPartInitialOrientations.addElement(partToAdd.getOrientationAsAxes((ReferenceFrame)partToAdd.getParent()));
            this.bodyParts.addElement(partToAdd);
        }

        private void setOrientation(Transformable part, Matrix33 initialOrient, Matrix33 finalOrient, double portion) {
            Matrix33 currentOrient = Matrix33.interpolate(initialOrient, finalOrient, portion);
            if (part != null) {
                part.setOrientationRightNow(currentOrient, (ReferenceFrame)part.getParent());
            }
        }
    }
}

