/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.response.DirectionAmountTransformAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import javax.vecmath.Vector3d;

public abstract class RotateAnimation
extends DirectionAmountTransformAnimation {
    @Override
    protected Direction getDefaultDirection() {
        return Direction.LEFT;
    }

    public abstract class RuntimeRotateAnimation
    extends DirectionAmountTransformAnimation.RuntimeDirectionAmountTransformAnimation {
        private Vector3d m_axis;
        private double m_amount;
        private double m_amountPrev;

        protected abstract Vector3d getAxis(Direction var1);

        @Override
        public void prologue(double t) {
            super.prologue(t);
            Direction directionValue = RotateAnimation.this.direction.getDirectionValue();
            this.m_amount = RotateAnimation.this.amount.doubleValue();
            this.m_axis = this.getAxis(directionValue);
            if (this.m_axis == null) {
                StringBuffer sb = new StringBuffer(Messages.getString("direction_value_must_not_be_"));
                if (directionValue != null) {
                    sb.append(directionValue.getRepr());
                } else {
                    sb.append(Messages.getString("null"));
                }
                sb.append('.');
                throw new SimulationPropertyException(sb.toString(), null, RotateAnimation.this.direction);
            }
            this.m_amountPrev = 0.0;
        }

        @Override
        public void update(double t) {
            super.update(t);
            double delta = this.m_amount * this.getPortion(t) - this.m_amountPrev;
            this.m_subject.rotateRightNow(this.m_axis, delta, this.m_asSeenBy);
            this.m_amountPrev += delta;
        }
    }
}

