/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Dimension;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.DimensionProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.util.HowMuch;
import javax.vecmath.Vector3d;

public class ResizeAnimation
extends TransformAnimation {
    public final DimensionProperty dimension = new DimensionProperty(this, "dimension", Dimension.ALL);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(2.0));
    public final BooleanProperty likeRubber = new BooleanProperty(this, "likeRubber", Boolean.FALSE);
    public final ObjectProperty howMuch = new ObjectProperty(this, "howMuch", HowMuch.INSTANCE_AND_PARTS, HowMuch.class);
    private static final Vector3d VECTOR_111 = new Vector3d(1.0, 1.0, 1.0);

    public class RuntimeResizeAnimation
    extends TransformAnimation.RuntimeTransformAnimation {
        private Vector3d m_vector;
        private Vector3d m_vectorPrev;
        private HowMuch m_howMuch;

        public RuntimeResizeAnimation() {
            super(ResizeAnimation.this);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_vectorPrev = new Vector3d(1.0, 1.0, 1.0);
            Dimension dimensionValue = ResizeAnimation.this.dimension.getDimensionValue();
            double amountValue = ResizeAnimation.this.amount.doubleValue();
            this.m_vector = Transformable.calculateResizeScale(dimensionValue, amountValue, ResizeAnimation.this.likeRubber.booleanValue());
            this.m_howMuch = (HowMuch)ResizeAnimation.this.howMuch.getValue();
        }

        @Override
        public void update(double t) {
            super.update(t);
            Vector3d vectorCurrent = MathUtilities.interpolate(VECTOR_111, this.m_vector, this.getPortion(t));
            this.m_subject.resizeRightNow(MathUtilities.divide(vectorCurrent, this.m_vectorPrev), this.m_asSeenBy, this.m_howMuch);
            this.m_vectorPrev = vectorCurrent;
        }
    }
}

