/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.ElementProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.response.Animation;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PoseAnimation
extends Animation {
    public final TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public final PoseProperty pose = new PoseProperty(this, "pose", null);

    public class PoseProperty
    extends ElementProperty {
        public PoseProperty(Element owner, String name, Pose defaultValue) {
            super(owner, name, defaultValue, Pose.class);
        }

        public Pose getPoseValue() {
            return (Pose)this.getElementValue();
        }
    }

    public class RuntimePoseAnimation
    extends Animation.RuntimeAnimation {
        protected Transformable subject;
        protected Pose pose;
        protected Dictionary poseStringMap;
        protected Vector transformableKeys = new Vector();
        protected Dictionary poseTransformableMap = new Hashtable();
        protected Dictionary sourcePositionMap = new Hashtable();
        protected Dictionary targetPositionMap = new Hashtable();
        protected Dictionary sourceQuaternionMap = new Hashtable();
        protected Dictionary targetQuaternionMap = new Hashtable();
        protected Dictionary sourceScaleMap = new Hashtable();
        protected Dictionary targetScaleMap = new Hashtable();

        @Override
        public void prologue(double t) {
            this.transformableKeys = new Vector();
            super.prologue(t);
            this.subject = PoseAnimation.this.subject.getTransformableValue();
            this.pose = PoseAnimation.this.pose.getPoseValue();
            Dictionary poseStringMap = this.pose.poseMap.getDictionaryValue();
            Enumeration enum0 = poseStringMap.keys();
            while (enum0.hasMoreElements()) {
                String stringKey = (String)enum0.nextElement();
                Transformable key = (Transformable)this.subject.getDescendantKeyed(stringKey);
                if (key != null) {
                    this.transformableKeys.add(key);
                    Matrix44 m = (Matrix44)poseStringMap.get(stringKey);
                    this.sourcePositionMap.put(key, key.getPosition());
                    this.sourceQuaternionMap.put(key, key.getOrientationAsQuaternion());
                    this.targetPositionMap.put(key, m.getPosition());
                    this.targetQuaternionMap.put(key, m.getAxes().getQuaternion());
                    continue;
                }
                System.err.println("Can't find " + stringKey + " in " + this.subject);
            }
        }

        @Override
        public void update(double t) {
            super.update(t);
            double portion = this.getPortion(t);
            Enumeration enum0 = this.transformableKeys.elements();
            while (enum0.hasMoreElements()) {
                Transformable key = (Transformable)enum0.nextElement();
                Vector3 sourcePosition = (Vector3)this.sourcePositionMap.get(key);
                Vector3 targetPosition = (Vector3)this.targetPositionMap.get(key);
                Quaternion sourceQuaternion = (Quaternion)this.sourceQuaternionMap.get(key);
                Quaternion targetQuaternion = (Quaternion)this.targetQuaternionMap.get(key);
                Vector3 currentPosition = Vector3.interpolate(sourcePosition, targetPosition, portion);
                Quaternion currentQuaternion = Quaternion.interpolate(sourceQuaternion, targetQuaternion, portion);
                key.setPositionRightNow(currentPosition);
                key.setOrientationRightNow(currentQuaternion);
            }
        }
    }
}

