/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.Matrix44Property;
import edu.cmu.cs.stage3.alice.core.response.OrientationAnimation;
import edu.cmu.cs.stage3.math.HermiteCubic;
import edu.cmu.cs.stage3.math.Interpolator;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;

public class PointOfViewAnimation
extends OrientationAnimation {
    public final Matrix44Property pointOfView = new Matrix44Property(this, "pointOfView", new Matrix44());
    public final BooleanProperty affectPosition = new BooleanProperty(this, "affectPosition", Boolean.TRUE);
    public final BooleanProperty affectQuaternion = new BooleanProperty(this, "affectQuaternion", Boolean.TRUE);
    public final BooleanProperty followHermiteCubic = new BooleanProperty(this, "followHermiteCubic", Boolean.FALSE);

    public class RuntimePointOfViewAnimation
    extends OrientationAnimation.RuntimeOrientationAnimation {
        private Matrix44 m_transformationBegin;
        private Matrix44 m_transformationEnd;
        private boolean m_affectPosition;
        private boolean m_affectQuaternion;
        private boolean m_followHermiteCubic;
        private HermiteCubic m_xHermite;
        private HermiteCubic m_yHermite;
        private HermiteCubic m_zHermite;

        @Override
        public void prologue(double t) {
            this.m_affectPosition = PointOfViewAnimation.this.affectPosition.booleanValue();
            this.m_affectQuaternion = PointOfViewAnimation.this.affectQuaternion.booleanValue();
            super.prologue(t);
            if (this.m_affectPosition) {
                this.m_followHermiteCubic = PointOfViewAnimation.this.followHermiteCubic.booleanValue();
                this.m_transformationBegin = this.m_subject.getTransformation(this.m_asSeenBy);
                this.m_transformationEnd = PointOfViewAnimation.this.pointOfView.getMatrix44Value();
                if (this.m_followHermiteCubic) {
                    double dx = this.m_transformationBegin.m30 - this.m_transformationEnd.m30;
                    double dy = this.m_transformationBegin.m31 - this.m_transformationEnd.m31;
                    double dz = this.m_transformationBegin.m32 - this.m_transformationEnd.m32;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    double s = distance / 2.0;
                    this.m_xHermite = new HermiteCubic(this.m_transformationBegin.m30, this.m_transformationEnd.m30, this.m_transformationBegin.m20 * s, this.m_transformationEnd.m20 * s);
                    this.m_yHermite = new HermiteCubic(this.m_transformationBegin.m31, this.m_transformationEnd.m31, this.m_transformationBegin.m21 * s, this.m_transformationEnd.m21 * s);
                    this.m_zHermite = new HermiteCubic(this.m_transformationBegin.m32, this.m_transformationEnd.m32, this.m_transformationBegin.m22 * s, this.m_transformationEnd.m22 * s);
                }
            }
        }

        @Override
        protected boolean affectQuaternion() {
            return this.m_affectQuaternion;
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            return this.m_transformationEnd.getAxes().getQuaternion();
        }

        @Override
        public void update(double t) {
            if (this.m_affectPosition) {
                double z;
                double y;
                double x;
                double portion = this.getPortion(t);
                if (this.m_followHermiteCubic) {
                    x = this.m_xHermite.evaluate(portion);
                    y = this.m_yHermite.evaluate(portion);
                    z = this.m_zHermite.evaluate(portion);
                } else {
                    x = Interpolator.interpolate(this.m_transformationBegin.m30, this.m_transformationEnd.m30, portion);
                    y = Interpolator.interpolate(this.m_transformationBegin.m31, this.m_transformationEnd.m31, portion);
                    z = Interpolator.interpolate(this.m_transformationBegin.m32, this.m_transformationEnd.m32, portion);
                }
                this.m_subject.setPositionRightNow(x, y, z, this.m_asSeenBy);
            }
            super.update(t);
        }

        @Override
        public void epilogue(double t) {
            if (this.m_affectPosition) {
                this.m_subject.setPositionRightNow(this.m_transformationEnd.m30, this.m_transformationEnd.m31, this.m_transformationEnd.m32, this.m_asSeenBy);
            }
            super.epilogue(t);
        }
    }
}

