/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.SpatialRelation;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.SpatialRelationProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractPositionAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import javax.vecmath.Vector3d;

public class PlaceAnimation
extends AbstractPositionAnimation {
    public final SpatialRelationProperty spatialRelation = new SpatialRelationProperty(this, "spatialRelation", SpatialRelation.IN_FRONT_OF);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(0.0));

    public class RuntimePlaceAnimation
    extends AbstractPositionAnimation.RuntimeAbstractPositionAnimation {
        private Box m_subjectBoundingBox;
        private Box m_asSeenByBoundingBox;

        public RuntimePlaceAnimation() {
            super(PlaceAnimation.this);
        }

        @Override
        protected Vector3d getPositionBegin() {
            return this.m_subject.getPosition(ReferenceFrame.ABSOLUTE);
        }

        @Override
        protected Vector3d getPositionEnd() {
            if (this.m_subjectBoundingBox == null) {
                this.m_subjectBoundingBox = this.m_subject.getBoundingBox();
                if (this.m_subjectBoundingBox.getMaximum() == null) {
                    this.m_subjectBoundingBox = new Box(this.m_subject.getPosition(this.m_subject), this.m_subject.getPosition(this.m_subject));
                }
            }
            if (this.m_asSeenByBoundingBox == null) {
                this.m_asSeenByBoundingBox = this.m_asSeenBy.getBoundingBox();
                if (this.m_asSeenByBoundingBox.getMaximum() == null) {
                    this.m_asSeenByBoundingBox = new Box(this.m_asSeenBy.getPosition(this.m_asSeenBy), this.m_asSeenBy.getPosition(this.m_asSeenBy));
                }
            }
            SpatialRelation sv = PlaceAnimation.this.spatialRelation.getSpatialRelationValue();
            Vector3d v = sv.getPlaceVector(PlaceAnimation.this.amount.doubleValue(), this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
            return this.m_asSeenBy.getPosition(v, ReferenceFrame.ABSOLUTE);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            if (PlaceAnimation.this.spatialRelation.getSpatialRelationValue() == null) {
                throw new SimulationPropertyException(Messages.getString("spatial_relation_value_must_not_be_null_"), null, PlaceAnimation.this.spatialRelation);
            }
            if (PlaceAnimation.this.amount.getValue() == null) {
                throw new SimulationPropertyException(Messages.getString("amount_value_must_not_be_null_"), null, PlaceAnimation.this.amount);
            }
        }
    }
}

