/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.response.DirectionSpeedTransformResponse;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Vector3d;

public class MoveAtSpeed
extends DirectionSpeedTransformResponse {
    public final BooleanProperty isScaledBySize = new BooleanProperty(this, "isScaledBySize", Boolean.FALSE);

    @Override
    protected Direction getDefaultDirection() {
        return Direction.FORWARD;
    }

    @Override
    protected boolean acceptsDirection(Direction direction) {
        return direction.getMoveAxis() != null;
    }

    public class RuntimeMoveAtSpeed
    extends DirectionSpeedTransformResponse.RuntimeDirectionSpeedTransformResponse {
        private Vector3d m_directionVector;

        public RuntimeMoveAtSpeed() {
            super(MoveAtSpeed.this);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            Direction directionValue = MoveAtSpeed.this.direction.getDirectionValue();
            if (directionValue != null) {
                this.m_directionVector = directionValue.getMoveAxis();
                if (MoveAtSpeed.this.isScaledBySize.booleanValue()) {
                    Vector3 subjectSize = this.m_subject.getSize();
                    this.m_directionVector.x *= subjectSize.x;
                    this.m_directionVector.y *= subjectSize.y;
                    this.m_directionVector.z *= subjectSize.z;
                }
            } else {
                this.m_directionVector = new Vector3d();
            }
        }

        @Override
        public void update(double t) {
            super.update(t);
            double delta = this.getDT() * this.getSpeed();
            this.m_subject.moveRightNow(MathUtilities.multiply(this.m_directionVector, delta), this.m_asSeenBy);
        }
    }
}

