/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.response.DirectionAmountTransformAnimation;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MoveAnimation
extends DirectionAmountTransformAnimation {
    public final BooleanProperty isScaledBySize = new BooleanProperty(this, "isScaledBySize", Boolean.FALSE);

    @Override
    protected Direction getDefaultDirection() {
        return Direction.FORWARD;
    }

    @Override
    protected boolean acceptsDirection(Direction direction) {
        return direction.getMoveAxis() != null;
    }

    public class RuntimeMoveAnimation
    extends DirectionAmountTransformAnimation.RuntimeDirectionAmountTransformAnimation {
        private Vector3d m_vector;
        private Vector3d m_vectorPrev;

        public RuntimeMoveAnimation() {
            super(MoveAnimation.this);
        }

        protected Vector3d getVector() {
            Direction directionValue = MoveAnimation.this.direction.getDirectionValue();
            double amountValue = MoveAnimation.this.amount.doubleValue();
            if (directionValue != null && !Double.isNaN(amountValue)) {
                Vector3d v = MathUtilities.multiply(directionValue.getMoveAxis(), amountValue);
                if (MoveAnimation.this.isScaledBySize.booleanValue()) {
                    Vector3 subjectSize = this.m_subject.getSize();
                    v.x *= subjectSize.x;
                    v.y *= subjectSize.y;
                    v.z *= subjectSize.z;
                }
                return v;
            }
            return new Vector3d();
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_vectorPrev = new Vector3d();
            this.m_vector = this.getVector();
        }

        @Override
        public void update(double t) {
            super.update(t);
            Vector3d delta = MathUtilities.subtract(MathUtilities.multiply(this.m_vector, this.getPortion(t)), this.m_vectorPrev);
            this.m_subject.moveRightNow(delta, this.m_asSeenBy);
            this.m_vectorPrev.add((Tuple3d)delta);
        }
    }
}

