/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractBodyPositionAnimation;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;

public class KneelAnimation
extends AbstractBodyPositionAnimation {
    public final BooleanProperty oneKnee = new BooleanProperty(this, "one knee", Boolean.TRUE);

    public class RuntimeKneelAnimation
    extends AbstractBodyPositionAnimation.RuntimeAbstractBodyPositionAnimation {
        public RuntimeKneelAnimation() {
            super(KneelAnimation.this);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.findLegs();
            this.getInitialOrientations();
            this.setFinalOrientations();
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            return this.m_subject.calculateStandUp(this.m_subject.getWorld()).getQuaternion();
        }

        @Override
        public void update(double t) {
            super.update(t);
            this.setOrientation(this.rightUpper, this.rightUpperInitialOrient, this.rightUpperFinalOrient, this.getPortion(t));
            this.setOrientation(this.rightLower, this.rightLowerInitialOrient, this.rightLowerFinalOrient, this.getPortion(t));
            if (this.rightFoot != null) {
                this.setOrientation(this.rightFoot, this.rightFootInitialOrient, this.rightFootFinalOrient, this.getPortion(t));
            }
            this.setOrientation(this.leftUpper, this.leftUpperInitialOrient, this.leftUpperFinalOrient, this.getPortion(t));
            this.setOrientation(this.leftLower, this.leftLowerInitialOrient, this.leftLowerFinalOrient, this.getPortion(t));
            if (this.leftFoot != null) {
                this.setOrientation(this.leftFoot, this.leftFootInitialOrient, this.leftFootFinalOrient, this.getPortion(t));
            }
            this.adjustHeight();
        }

        public void setFinalOrientations() {
            this.rightUpperFinalOrient = new Matrix33();
            this.rightLowerFinalOrient = new Matrix33();
            this.rightLowerFinalOrient.rotateX(1.5707963267948966);
            this.rightFootFinalOrient = new Matrix33();
            this.rightFootFinalOrient.rotateX(1.5707963267948966);
            if (KneelAnimation.this.oneKnee.booleanValue()) {
                double lengthSupportLeg = 0.0;
                if (this.rightLower == null) {
                    this.leftUpperFinalOrient = new Matrix33();
                    this.leftUpperFinalOrient.rotateX(0.7853981633974483);
                    this.leftFootFinalOrient = new Matrix33();
                    this.leftFootFinalOrient.rotateX(-0.7853981633974483);
                    this.rightUpperFinalOrient = new Matrix33();
                    this.rightUpperFinalOrient.rotateX(-0.7853981633974483);
                    this.rightFootFinalOrient = new Matrix33();
                    this.rightFootFinalOrient.rotateX(0.7853981633974483);
                }
                if (this.rightUpper != null && this.rightLower != null) {
                    Vector3 posLower = this.rightLower.getPosition(this.rightUpper);
                    Box boxLower = this.rightLower.getBoundingBox(this.rightLower);
                    lengthSupportLeg = Math.abs(posLower.y) + Math.abs(boxLower.getMinimum().z);
                    double lengthLowerLeg = 0.0;
                    lengthLowerLeg = this.leftFoot != null ? Math.abs(this.leftFoot.getPosition((ReferenceFrame)this.leftLower).y) + Math.abs(this.leftFoot.getBoundingBox((ReferenceFrame)this.leftFoot).getMinimum().z) : Math.abs(this.leftLower.getBoundingBox((ReferenceFrame)this.leftLower).getMinimum().y);
                    double diff = lengthSupportLeg - lengthLowerLeg;
                    double angle = Math.asin(Math.abs(diff) / Math.abs(posLower.y));
                    if (lengthSupportLeg * 2.0 < lengthLowerLeg) {
                        this.leftUpperFinalOrient = new Matrix33();
                        this.leftLowerFinalOrient = new Matrix33();
                        this.leftLowerFinalOrient.rotateX(0.7853981633974483);
                        this.leftFootFinalOrient = new Matrix33();
                        this.leftFootFinalOrient.rotateX(-0.7853981633974483);
                        this.rightUpperFinalOrient = new Matrix33();
                        this.rightLowerFinalOrient = new Matrix33();
                        this.rightLowerFinalOrient.rotateX(-0.7853981633974483);
                        this.rightFootFinalOrient = new Matrix33();
                        this.rightFootFinalOrient.rotateX(0.7853981633974483);
                    } else if (diff < 0.0) {
                        this.leftUpperFinalOrient = new Matrix33();
                        this.leftUpperFinalOrient.rotateX(-1.5707963267948966 - angle);
                        this.leftLowerFinalOrient = new Matrix33();
                        this.leftLowerFinalOrient.rotateX(1.5707963267948966 + angle);
                        this.leftFootFinalOrient = new Matrix33();
                    } else {
                        this.leftUpperFinalOrient = new Matrix33();
                        this.leftUpperFinalOrient.rotateX(-1.5707963267948966 + angle);
                        this.leftLowerFinalOrient = new Matrix33();
                        this.leftLowerFinalOrient.rotateX(1.5707963267948966 - angle);
                        this.leftFootFinalOrient = new Matrix33();
                    }
                }
            } else if (this.rightLower == null) {
                this.leftUpperFinalOrient = new Matrix33();
                this.leftUpperFinalOrient.rotateX(1.5707963267948966);
                this.leftFootFinalOrient = new Matrix33();
                this.leftFootFinalOrient.rotateX(1.5707963267948966);
                this.rightUpperFinalOrient = new Matrix33();
                this.rightUpperFinalOrient.rotateX(1.5707963267948966);
                this.rightFootFinalOrient = new Matrix33();
                this.rightFootFinalOrient.rotateX(1.5707963267948966);
            } else {
                this.leftUpperFinalOrient = new Matrix33();
                this.leftLowerFinalOrient = new Matrix33();
                this.leftLowerFinalOrient.rotateX(1.5707963267948966);
                this.leftFootFinalOrient = new Matrix33();
                this.leftFootFinalOrient.rotateX(1.5707963267948966);
            }
        }
    }
}

