/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Limb;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.property.LimbProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractBodyPositionAnimation;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class KeepTouchingAnimation
extends AbstractBodyPositionAnimation {
    public final TransformableProperty target = new TransformableProperty((Element)this, "target", null);
    public final LimbProperty limb = new LimbProperty(this, "limb", Limb.rightArm);
    public final DirectionProperty sideToTouch = new DirectionProperty(this, "side", Direction.FORWARD);
    public final NumberProperty offset = new NumberProperty(this, "offset", new Double(0.1));

    public class RuntimeTouchAnimation
    extends AbstractBodyPositionAnimation.RuntimeAbstractBodyPositionAnimation {
        Transformable m_target;
        Quaternion initialQuat;
        Quaternion initialLowerQuat;
        Quaternion upperTargetQuat;
        Quaternion lowerTargetQuat;
        double upperLimbLength;
        double lowerLimbLength;
        double limbAngle;
        Transformable upperLimb;
        Transformable lowerLimb;
        Vector3 initialVector;
        Vector3 targetVector;

        public RuntimeTouchAnimation() {
            super(KeepTouchingAnimation.this);
            this.initialQuat = null;
            this.initialLowerQuat = null;
            this.upperTargetQuat = null;
            this.lowerTargetQuat = null;
            this.upperLimbLength = -1.0;
            this.lowerLimbLength = -1.0;
            this.limbAngle = 0.0;
            this.upperLimb = null;
            this.lowerLimb = null;
            this.initialVector = null;
            this.targetVector = null;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            if (KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.leftArm) || KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.rightArm)) {
                this.findArms();
                if (KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.leftArm)) {
                    this.upperLimb = this.leftUpperArm;
                    this.lowerLimb = this.leftLowerArm;
                } else {
                    this.upperLimb = this.rightUpperArm;
                    this.lowerLimb = this.rightLowerArm;
                }
            } else {
                this.findLegs();
                if (KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.leftLeg)) {
                    this.upperLimb = this.leftUpper;
                    this.lowerLimb = this.leftLower;
                } else {
                    this.upperLimb = this.rightUpper;
                    this.lowerLimb = this.rightLower;
                }
            }
            this.m_target = KeepTouchingAnimation.this.target.getTransformableValue();
            this.m_asSeenBy = KeepTouchingAnimation.this.asSeenBy.getReferenceFrameValue();
            this.initialQuat = this.upperLimb.getOrientationAsQuaternion((ReferenceFrame)this.upperLimb.getParent());
            this.initialLowerQuat = null;
            if (this.lowerLimb != null) {
                this.initialLowerQuat = this.lowerLimb.getOrientationAsQuaternion((ReferenceFrame)this.lowerLimb.getParent());
            }
            this.upperTargetQuat = null;
            this.lowerTargetQuat = null;
            this.limbAngle = 0.0;
            this.upperLimbLength = -1.0;
            this.lowerLimbLength = -1.0;
            this.initialVector = null;
            Object tmp = null;
        }

        Vector3 getTargetPosition() {
            ReferenceFrame asb = this.m_asSeenBy;
            if (asb == null) {
                asb = this.upperLimb;
            }
            Vector3d targPos = this.m_target.getBoundingBox(asb).getCenter();
            Vector3 offsetDir = null;
            if (KeepTouchingAnimation.this.sideToTouch.getDirectionValue().equals(Direction.BACKWARD)) {
                targPos = this.m_target.getBoundingBox(this.m_target).getCenterOfBackFace();
                offsetDir = this.m_target.getOrientationAsAxes(asb).getRow(2);
                offsetDir.negate();
            } else if (KeepTouchingAnimation.this.sideToTouch.getDirectionValue().equals(Direction.UP)) {
                targPos = this.m_target.getBoundingBox(this.m_target).getCenterOfTopFace();
                offsetDir = this.m_target.getOrientationAsAxes(asb).getRow(1);
            } else if (KeepTouchingAnimation.this.sideToTouch.getDirectionValue().equals(Direction.DOWN)) {
                targPos = this.m_target.getBoundingBox(this.m_target).getCenterOfBottomFace();
                offsetDir = this.m_target.getOrientationAsAxes(asb).getRow(1);
                offsetDir.negate();
            } else if (KeepTouchingAnimation.this.sideToTouch.getDirectionValue().equals(Direction.LEFT)) {
                targPos = this.m_target.getBoundingBox(this.m_target).getCenterOfLeftFace();
                offsetDir = this.m_target.getOrientationAsAxes(asb).getRow(0);
            } else if (KeepTouchingAnimation.this.sideToTouch.getDirectionValue().equals(Direction.RIGHT)) {
                targPos = this.m_target.getBoundingBox(this.m_target).getCenterOfRightFace();
                offsetDir = this.m_target.getOrientationAsAxes(asb).getRow(0);
                offsetDir.negate();
            } else {
                targPos = this.m_target.getBoundingBox(this.m_target).getCenterOfFrontFace();
                offsetDir = this.m_target.getOrientationAsAxes(asb).getRow(2);
            }
            targPos = this.m_target.getPosition(targPos, this.upperLimb);
            if (KeepTouchingAnimation.this.offset.doubleValue() != 0.0) {
                offsetDir.scale(KeepTouchingAnimation.this.offset.doubleValue());
                targPos.add((Tuple3d)offsetDir);
            }
            Vector3 targPos2 = new Vector3(targPos.x, targPos.y, targPos.z);
            targPos.normalize();
            return targPos2;
        }

        @Override
        public void update(double t) {
            if (this.getPortion(t) <= 1.0) {
                this.setTargetQuaternions();
                this.upperTargetQuat = this.getTargetQuaternion();
                this.lowerTargetQuat = this.getLowerTargetQuaternion();
                this.upperLimb.setOrientationRightNow(this.upperTargetQuat, (ReferenceFrame)this.upperLimb.getParent());
                if (this.lowerLimb != null) {
                    this.lowerLimb.setOrientationRightNow(this.lowerTargetQuat, (ReferenceFrame)this.lowerLimb.getParent());
                }
            }
        }

        double getLength(Vector3 vec) {
            return Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
        }

        double getAngle(Vector3 a, Vector3 b) {
            Vector3 c = Vector3.subtract(a, b);
            double cLength = this.getLength(c);
            double aLength = this.getLength(a);
            double bLength = this.getLength(b);
            double cosC = (cLength * cLength - aLength * aLength - bLength * bLength) / (-2.0 * aLength * bLength);
            return Math.acos(cosC);
        }

        protected void setArmLengths() {
            if (this.upperLimb != null && this.lowerLimb != null) {
                Vector3 tmp = Vector3.subtract(this.lowerLimb.getPosition(this.lowerLimb), this.lowerLimb.getBoundingBox(this.lowerLimb).getCenterOfBottomFace());
                this.lowerLimbLength = tmp.getLength();
                this.upperLimbLength = this.upperLimb.getPosition((ReferenceFrame)this.upperLimb).y - this.lowerLimb.getPosition((ReferenceFrame)this.upperLimb).y;
            } else {
                this.upperLimbLength = this.upperLimb.getPosition((ReferenceFrame)this.upperLimb).y - this.upperLimb.getBoundingBox((ReferenceFrame)this.upperLimb).getCenterOfBottomFace().y;
                this.lowerLimbLength = 0.0;
            }
        }

        protected void setVectors() {
            Vector3 rightUpperPos = this.upperLimb.getPosition(this.upperLimb);
            Vector3 targetPos = this.getTargetPosition();
            this.targetVector = Vector3.subtract(targetPos, rightUpperPos);
            Vector3d currentDir = null;
            if (this.lowerLimb == null) {
                currentDir = this.upperLimb.getBoundingBox(this.upperLimb).getCenterOfBottomFace();
            } else {
                currentDir = this.lowerLimb.getBoundingBox(this.lowerLimb).getCenterOfBottomFace();
                currentDir = this.lowerLimb.getPosition(currentDir, this.upperLimb);
            }
            this.initialVector = new Vector3(currentDir.x, currentDir.y, currentDir.z);
        }

        protected void setTargetQuaternions() {
            Matrix44 initialTrans = null;
            if (this.lowerLimb != null) {
                initialTrans = this.lowerLimb.getTransformation((ReferenceFrame)this.lowerLimb.getParent());
            }
            Matrix44 initialUpperTrans = this.upperLimb.getTransformation((ReferenceFrame)this.upperLimb.getParent());
            if (this.lowerLimb != null) {
                this.lowerLimb.setOrientationRightNow(new Matrix33(), (ReferenceFrame)this.lowerLimb.getParent());
            }
            this.upperLimb.setOrientationRightNow(new Matrix33(), (ReferenceFrame)this.upperLimb.getParent());
            this.setArmLengths();
            this.setVectors();
            double targetDistance = this.targetVector.length();
            this.limbAngle = 0.0;
            if (targetDistance < this.upperLimbLength + this.lowerLimbLength) {
                double cosAngle = (targetDistance * targetDistance - this.upperLimbLength * this.upperLimbLength - this.lowerLimbLength * this.lowerLimbLength) / (-2.0 * this.upperLimbLength * this.lowerLimbLength);
                this.limbAngle = (Math.PI - Math.acos(cosAngle)) / (Math.PI * 2);
                if (!Double.isNaN(this.limbAngle)) {
                    if (KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.leftArm) || KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.rightArm)) {
                        if (this.lowerLimb != null) {
                            this.lowerLimb.turnRightNow(Direction.BACKWARD, this.limbAngle);
                            this.upperLimb.turnRightNow(Direction.FORWARD, this.limbAngle / 2.0);
                        }
                    } else if (this.lowerLimb != null) {
                        this.lowerLimb.turnRightNow(Direction.FORWARD, this.limbAngle);
                        this.upperLimb.turnRightNow(Direction.BACKWARD, this.limbAngle / 2.0);
                    }
                }
            }
            double angle = this.getAngle(this.initialVector, this.targetVector);
            Vector3 cross = Vector3.crossProduct(this.initialVector, this.targetVector);
            cross.normalize();
            this.upperLimb.rotateRightNow(cross, angle / (Math.PI * 2), (ReferenceFrame)this.upperLimb.getParent());
            this.targetVector.normalize();
            double turnAmt = 0.0;
            if (KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.rightArm)) {
                if (this.targetVector.x < 0.0) {
                    turnAmt = 0.25 + -0.1 * this.targetVector.x;
                }
                if (this.targetVector.z < 0.3) {
                    turnAmt += 1.0 * (0.3 - this.targetVector.z);
                }
                if (turnAmt > 0.0) {
                    this.upperLimb.rotateRightNow(this.targetVector, turnAmt, (ReferenceFrame)this.upperLimb.getParent());
                }
            } else if (KeepTouchingAnimation.this.limb.getLimbValue().equals(Limb.leftArm)) {
                if (this.targetVector.x > 0.0) {
                    turnAmt = 0.25 + -0.1 * this.targetVector.x;
                }
                if (this.targetVector.z < 0.5) {
                    turnAmt += 1.0 * (0.3 - this.targetVector.z);
                }
                if (Math.abs(turnAmt) > 0.0) {
                    this.upperLimb.rotateRightNow(this.targetVector, -1.0 * turnAmt, (ReferenceFrame)this.upperLimb.getParent());
                }
            }
            this.lowerTargetQuat = null;
            if (this.lowerLimb != null) {
                this.lowerTargetQuat = this.lowerLimb.getOrientationAsQuaternion((ReferenceFrame)this.lowerLimb.getParent());
                if (Double.isNaN(this.limbAngle)) {
                    this.lowerLimb.setTransformationRightNow(initialTrans, (ReferenceFrame)this.lowerLimb.getParent());
                    this.lowerTargetQuat = this.lowerLimb.getOrientationAsQuaternion((ReferenceFrame)this.lowerLimb.getParent());
                }
            }
            this.upperTargetQuat = this.upperLimb.getOrientationAsQuaternion((ReferenceFrame)this.upperLimb.getParent());
            if (this.lowerLimb != null) {
                this.lowerLimb.setTransformationRightNow(initialTrans, (ReferenceFrame)this.lowerLimb.getParent());
            }
            this.upperLimb.setTransformationRightNow(initialUpperTrans, (ReferenceFrame)this.upperLimb.getParent());
        }

        public Quaternion getLowerTargetQuaternion() {
            if (this.lowerTargetQuat == null) {
                this.setTargetQuaternions();
            }
            return this.lowerTargetQuat;
        }

        @Override
        public Quaternion getTargetQuaternion() {
            if (this.upperTargetQuat == null) {
                this.setTargetQuaternions();
            }
            return this.upperTargetQuat;
        }
    }
}

