/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.response.OrientationAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Interpolator;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;

public class GetAGoodLookAtAnimation
extends OrientationAnimation {
    public final ReferenceFrameProperty target = new ReferenceFrameProperty((Element)this, "target", null);

    public class RuntimeGetAGoodLookAtAnimation
    extends OrientationAnimation.RuntimeOrientationAnimation {
        private ReferenceFrame m_target;
        private Matrix44 m_transformationBegin;
        private Matrix44 m_transformationEnd;

        public RuntimeGetAGoodLookAtAnimation() {
            super(GetAGoodLookAtAnimation.this);
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_target = GetAGoodLookAtAnimation.this.target.getReferenceFrameValue();
            if (this.m_target == null) {
                throw new SimulationPropertyException(Messages.getString("target_value_must_not_be_null_"), null, GetAGoodLookAtAnimation.this.target);
            }
            if (this.m_target == this.m_subject) {
                throw new SimulationPropertyException(Messages.getString("target_value_must_not_be_equal_to_the_subject_value_"), this.getCurrentStack(), GetAGoodLookAtAnimation.this.target);
            }
            this.m_transformationBegin = this.m_subject.getTransformation(this.m_asSeenBy);
            this.m_transformationEnd = new Matrix44(this.m_subject.calculateGoodLookAt(this.m_target, this.m_asSeenBy));
        }

        @Override
        protected boolean affectQuaternion() {
            return true;
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            return this.m_transformationEnd.getAxes().getQuaternion();
        }

        @Override
        public void update(double t) {
            double portion = this.getPortion(t);
            double x = Interpolator.interpolate(this.m_transformationBegin.m30, this.m_transformationEnd.m30, portion);
            double y = Interpolator.interpolate(this.m_transformationBegin.m31, this.m_transformationEnd.m31, portion);
            double z = Interpolator.interpolate(this.m_transformationBegin.m32, this.m_transformationEnd.m32, portion);
            this.m_subject.setPositionRightNow(x, y, z, this.m_asSeenBy);
            super.update(t);
        }

        @Override
        public void epilogue(double t) {
            if (this.m_subject != null && this.m_transformationEnd != null) {
                this.m_subject.setPositionRightNow(this.m_transformationEnd.m30, this.m_transformationEnd.m31, this.m_transformationEnd.m32, this.m_asSeenBy);
            }
            super.epilogue(t);
        }
    }
}

