/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.property.DirectionProperty;
import edu.cmu.cs.stage3.alice.core.response.AbstractBodyPositionAnimation;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.util.HowMuch;
import javax.vecmath.Vector3d;

public class FallDownAnimation
extends AbstractBodyPositionAnimation {
    public final DirectionProperty sideToFallOn = new DirectionProperty(this, "sideToFallOn", Direction.FORWARD);

    public class RuntimeFallDownAnimation
    extends AbstractBodyPositionAnimation.RuntimeAbstractBodyPositionAnimation {
        private Vector3d m_positionBegin;
        private Vector3d m_positionEnd;
        private Direction m_side;

        public RuntimeFallDownAnimation() {
            super(FallDownAnimation.this);
            this.m_side = null;
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_positionBegin = this.m_subject.getPosition(this.m_subject.getWorld());
            this.m_positionEnd = null;
            this.m_side = FallDownAnimation.this.sideToFallOn.getDirectionValue();
            this.findLegs();
            this.findArms();
            this.getInitialOrientations();
            this.setFinalOrientations();
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_positionEnd == null) {
                this.m_positionEnd = this.getPositionEnd();
            }
            this.m_subject.setPositionRightNow(MathUtilities.interpolate(this.m_positionBegin, this.m_positionEnd, this.getPortion(t)), ReferenceFrame.ABSOLUTE);
            this.setOrientation(this.rightUpperArm, this.rightUpperArmInitialOrient, this.rightUpperArmFinalOrient, this.getPortion(t));
            this.setOrientation(this.rightLowerArm, this.rightLowerArmInitialOrient, this.rightLowerArmFinalOrient, this.getPortion(t));
            this.setOrientation(this.leftUpperArm, this.leftUpperArmInitialOrient, this.leftUpperArmFinalOrient, this.getPortion(t));
            this.setOrientation(this.leftLowerArm, this.leftLowerArmInitialOrient, this.leftLowerArmFinalOrient, this.getPortion(t));
            this.adjustHeight();
        }

        protected Vector3d getPositionEnd() {
            Vector3 endPos = this.m_subject.getPosition(this.m_subject.getWorld());
            double pivotToGround = this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfBottomFace().y;
            double pivotToFront = 0.0;
            if (this.m_side.equals(Direction.FORWARD)) {
                pivotToFront = this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject).getCenterOfFrontFace().z;
                if (this.leftUpper != null && this.leftUpper.getBoundingBox(this.leftUpper, HowMuch.INSTANCE).getMinimum() != null) {
                    pivotToFront = this.leftUpper.getBoundingBox((ReferenceFrame)this.leftUpper, (HowMuch)HowMuch.INSTANCE).getCenterOfFrontFace().z;
                }
            } else if (this.m_side.equals(Direction.BACKWARD)) {
                pivotToFront = this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject).getCenterOfBackFace().z;
                if (this.leftUpper != null && this.leftUpper.getBoundingBox(this.leftUpper, HowMuch.INSTANCE).getMinimum() != null) {
                    pivotToFront = -1.0 * this.leftUpper.getBoundingBox((ReferenceFrame)this.leftUpper, (HowMuch)HowMuch.INSTANCE).getCenterOfBackFace().z;
                }
            } else if (this.m_side.equals(Direction.LEFT)) {
                pivotToFront = -0.8 * this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject).getCenterOfLeftFace().x;
            } else if (this.m_side.equals(Direction.RIGHT)) {
                pivotToFront = -0.8 * this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject).getCenterOfLeftFace().x;
            }
            endPos.y = endPos.y - pivotToGround + 0.9 * pivotToFront;
            return endPos;
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            Matrix44 quat = this.m_subject.getTransformation(this.m_subject.getWorld());
            this.m_subject.standUpRightNow();
            if (this.m_side.equals(Direction.FORWARD)) {
                this.m_subject.turnRightNow(Direction.FORWARD, 0.25);
            } else if (this.m_side.equals(Direction.BACKWARD)) {
                this.m_subject.turnRightNow(Direction.BACKWARD, 0.25);
            } else if (this.m_side.equals(Direction.LEFT)) {
                this.m_subject.rollRightNow(Direction.LEFT, 0.25);
            } else if (this.m_side.equals(Direction.RIGHT)) {
                this.m_subject.rollRightNow(Direction.RIGHT, 0.25);
            }
            Matrix33 orient = this.m_subject.getOrientationAsAxes(this.m_subject.getWorld());
            this.m_subject.setAbsoluteTransformationRightNow(quat);
            return orient.getQuaternion();
        }

        public void setFinalOrientations() {
            if (this.m_side.equals(Direction.LEFT) || this.m_side.equals(Direction.RIGHT)) {
                this.rightUpperArmFinalOrient = new Matrix33();
                this.rightUpperArmFinalOrient.rotateX(Math.random() * -0.5 * Math.PI);
                this.leftUpperArmFinalOrient = new Matrix33();
                this.leftUpperArmFinalOrient.rotateX(Math.random() * -0.5 * Math.PI);
                this.rightLowerArmFinalOrient = new Matrix33();
                this.rightLowerArmFinalOrient.rotateX(Math.random() * -0.5 * Math.PI);
                this.leftLowerArmFinalOrient = new Matrix33();
                this.leftLowerArmFinalOrient.rotateX(Math.random() * -0.5 * Math.PI);
            } else if (this.m_side.equals(Direction.FORWARD) || this.m_side.equals(Direction.BACKWARD)) {
                this.rightUpperArmFinalOrient = new Matrix33();
                this.rightUpperArmFinalOrient.rotateZ(Math.random() * 0.5 * Math.PI);
                this.leftUpperArmFinalOrient = new Matrix33();
                this.leftUpperArmFinalOrient.rotateZ(Math.random() * -0.5 * Math.PI);
                this.rightLowerArmFinalOrient = new Matrix33();
                this.rightLowerArmFinalOrient.rotateZ(Math.random() * 0.5 * Math.PI);
                this.leftLowerArmFinalOrient = new Matrix33();
                this.leftLowerArmFinalOrient.rotateZ(Math.random() * -0.5 * Math.PI);
            }
        }
    }
}

