/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.SpatialRelation;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.SpatialRelationProperty;
import edu.cmu.cs.stage3.alice.core.property.Vector3Property;
import edu.cmu.cs.stage3.alice.core.response.AbstractPositionAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix33;
import javax.vecmath.Vector3d;

public class CloseUpAnimation
extends AbstractPositionAnimation {
    public final Vector3Property position = new Vector3Property(this, "position", new Vector3d(0.0, 0.0, 0.0));
    public final SpatialRelationProperty spatialRelation = new SpatialRelationProperty(this, "spatialRelation", SpatialRelation.IN_FRONT_OF);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(1.0));
    private Matrix33 m_cameraEndOrientation;
    private Matrix33 m_cameraBeginOrientation;

    public static CloseUpAnimation createCloseUpAnimation(Object subject, Object spatialRelation, Object amount, Object asSeenBy) {
        CloseUpAnimation closeUpAnimation = new CloseUpAnimation();
        closeUpAnimation.subject.set(subject);
        closeUpAnimation.spatialRelation.set(spatialRelation);
        closeUpAnimation.amount.set(amount);
        closeUpAnimation.asSeenBy.set(asSeenBy);
        return closeUpAnimation;
    }

    public class RuntimeCloseUpAnimation
    extends AbstractPositionAnimation.RuntimeAbstractPositionAnimation {
        private Box m_subjectBoundingBox;
        private Box m_asSeenByBoundingBox;
        private double m_amount;
        private double m_cameraHeight;

        @Override
        protected Vector3d getPositionBegin() {
            CloseUpAnimation.this.m_cameraBeginOrientation = this.m_subject.getOrientationAsAxes(this.m_asSeenBy);
            return this.m_subject.getPosition(ReferenceFrame.ABSOLUTE);
        }

        @Override
        protected Vector3d getPositionEnd() {
            if (this.m_subjectBoundingBox == null) {
                this.m_subjectBoundingBox = this.m_subject.getBoundingBox();
                if (this.m_subjectBoundingBox.getMaximum() == null) {
                    this.m_subjectBoundingBox = new Box(this.m_subject.getPosition(this.m_subject), this.m_subject.getPosition(this.m_subject));
                }
            }
            if (this.m_asSeenByBoundingBox == null) {
                this.m_asSeenByBoundingBox = this.m_asSeenBy.getBoundingBox();
                if (this.m_asSeenByBoundingBox.getMaximum() == null) {
                    this.m_asSeenByBoundingBox = new Box(this.m_asSeenBy.getPosition(this.m_asSeenBy), this.m_asSeenBy.getPosition(this.m_asSeenBy));
                }
            }
            SpatialRelation sv = CloseUpAnimation.this.spatialRelation.getSpatialRelationValue();
            Matrix33 cameraEndOrientation = this.m_asSeenBy.getOrientationAsAxes(this.m_asSeenBy);
            if (sv.equals(SpatialRelation.LEFT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(1.0, 0.0, 0.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.RIGHT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(-1.0, 0.0, 0.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.BEHIND_RIGHT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(-0.7071068, 0.0, 0.7071068), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.BEHIND_LEFT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.7071068, 0.0, 0.7071068), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.FRONT_RIGHT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(-0.7071068, 0.0, -0.7071068), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.FRONT_LEFT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.7071068, 0.0, -0.7071068), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.IN_FRONT_OF)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, -1.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.BEHIND)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 0.0, 1.0), cameraEndOrientation.getRow(1));
            } else if (sv.equals(SpatialRelation.ABOVE)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, -1.0, 0.0), new Vector3d(-1.0, 0.0, 0.0));
            } else if (sv.equals(SpatialRelation.BELOW)) {
                cameraEndOrientation.setForwardUpGuide(new Vector3d(0.0, 1.0, 0.0), new Vector3d(-1.0, 0.0, 0.0));
            }
            CloseUpAnimation.this.m_cameraEndOrientation = cameraEndOrientation;
            this.m_amount = CloseUpAnimation.this.amount.doubleValue() * this.m_asSeenBy.getHeight() * 3.0;
            Vector3d v = sv.getPlaceVector(this.m_amount, this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
            double halfViewable = this.m_asSeenBy.getHeight() * 1.5 * CloseUpAnimation.this.amount.doubleValue() / 2.0;
            double startingHeight = (1.0 - CloseUpAnimation.this.amount.doubleValue()) * this.m_asSeenByBoundingBox.getHeight();
            v.y = this.m_cameraHeight = startingHeight + halfViewable + this.m_asSeenByBoundingBox.getMinimum().y;
            return this.m_asSeenBy.getPosition(v, ReferenceFrame.ABSOLUTE);
        }

        @Override
        public void prologue(double t) {
            this.m_asSeenBy = CloseUpAnimation.this.asSeenBy.getReferenceFrameValue();
            this.m_amount = CloseUpAnimation.this.amount.getNumberValue().doubleValue();
            if (this.m_asSeenBy == null) {
                throw new SimulationPropertyException(Messages.getString("character_value_must_not_be_null_"), this.getCurrentStack(), CloseUpAnimation.this.asSeenBy);
            }
            super.prologue(t);
            if (this.m_subject == null) {
                throw new SimulationPropertyException(Messages.getString("subject_value_must_not_be_null_"), this.getCurrentStack(), CloseUpAnimation.this.subject);
            }
            if (this.m_subject == this.m_asSeenBy) {
                throw new SimulationPropertyException(Messages.getString("subject_and_character_values_must_not_be_the_same_"), this.getCurrentStack(), CloseUpAnimation.this.subject);
            }
            if (this.m_amount < 0.0) {
                throw new SimulationPropertyException(Messages.getString("amount_must_be_greater_than_0"), this.getCurrentStack(), CloseUpAnimation.this.amount);
            }
        }

        @Override
        public void update(double t) {
            super.update(t);
            Matrix33 nextOrient = Matrix33.interpolate(CloseUpAnimation.this.m_cameraBeginOrientation, CloseUpAnimation.this.m_cameraEndOrientation, this.getPortion(t));
            this.m_subject.setOrientationRightNow(nextOrient, this.m_asSeenBy);
        }
    }
}

