/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNamedCriterion;
import edu.cmu.cs.stage3.alice.core.response.AbstractPositionAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix33;
import javax.vecmath.Vector3d;

public class CharacterViewAnimation
extends AbstractPositionAnimation {
    public static CharacterViewAnimation createCharacterViewAnimation(Object subject, Object asSeenBy) {
        CharacterViewAnimation charViewAnimation = new CharacterViewAnimation();
        charViewAnimation.subject.set(subject);
        charViewAnimation.asSeenBy.set(asSeenBy);
        return charViewAnimation;
    }

    public class RuntimeCloseUpAnimation
    extends AbstractPositionAnimation.RuntimeAbstractPositionAnimation {
        private Box m_subjectBoundingBox;
        private Model m_characterHead;
        private Matrix33 m_orientationBegin;
        private Matrix33 m_orientationEnd;

        public RuntimeCloseUpAnimation() {
            super(CharacterViewAnimation.this);
            this.m_characterHead = null;
            this.m_orientationBegin = null;
            this.m_orientationEnd = null;
        }

        @Override
        protected Vector3d getPositionBegin() {
            return this.m_subject.getPosition(ReferenceFrame.ABSOLUTE);
        }

        @Override
        protected Vector3d getPositionEnd() {
            Vector3d v = new Vector3d(0.0, 0.0, 0.0);
            if (CharacterViewAnimation.this.asSeenBy.get() instanceof Model) {
                Model character = (Model)CharacterViewAnimation.this.asSeenBy.get();
                Element[] heads = character.search(new ElementNamedCriterion("head", true));
                if (heads.length > 0 && heads[0] instanceof Model) {
                    this.m_characterHead = (Model)heads[0];
                    v = this.m_characterHead.getBoundingBox().getCenterOfFrontFace();
                    return this.m_characterHead.getPosition(v, ReferenceFrame.ABSOLUTE);
                }
                v = character.getBoundingBox().getCenterOfFrontFace();
                v.y *= 1.8;
                return character.getPosition(v, ReferenceFrame.ABSOLUTE);
            }
            return this.m_asSeenBy.getPosition(v, ReferenceFrame.ABSOLUTE);
        }

        protected Matrix33 getOrientationBegin() {
            return this.m_subject.getOrientationAsAxes(ReferenceFrame.ABSOLUTE);
        }

        protected Matrix33 getOrientationEnd() {
            if (this.m_characterHead != null) {
                return this.m_characterHead.getOrientationAsAxes(ReferenceFrame.ABSOLUTE);
            }
            return this.m_asSeenBy.getOrientationAsAxes(ReferenceFrame.ABSOLUTE);
        }

        @Override
        public void prologue(double t) {
            this.m_asSeenBy = CharacterViewAnimation.this.asSeenBy.getReferenceFrameValue();
            if (this.m_asSeenBy == null) {
                throw new SimulationPropertyException(Messages.getString("character_value_must_not_be_null_"), this.getCurrentStack(), CharacterViewAnimation.this.asSeenBy);
            }
            super.prologue(t);
            if (this.m_subject == this.m_asSeenBy) {
                throw new SimulationPropertyException(Messages.getString("subject_and_character_values_must_not_be_the_same_"), this.getCurrentStack(), CharacterViewAnimation.this.subject);
            }
            this.m_orientationBegin = this.getOrientationBegin();
            this.m_orientationEnd = null;
        }

        @Override
        public void update(double t) {
            super.update(t);
            if (this.m_orientationEnd == null) {
                this.m_orientationEnd = this.getOrientationEnd();
            }
            this.m_subject.setOrientationRightNow(Matrix33.interpolate(this.m_orientationBegin, this.m_orientationEnd, this.getPortion(t)), ReferenceFrame.ABSOLUTE);
        }
    }
}

