/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.SpatialRelation;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.SpatialRelationProperty;
import edu.cmu.cs.stage3.alice.core.response.PointOfViewAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BetterPlaceAnimation
extends PointOfViewAnimation {
    public final SpatialRelationProperty spatialRelation = new SpatialRelationProperty(this, "spatialRelation", SpatialRelation.IN_FRONT_OF);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(0.0));

    public class RuntimeBetterPlaceAnimation
    extends PointOfViewAnimation.RuntimePointOfViewAnimation {
        private Box m_subjectBoundingBox;
        private Box m_asSeenByBoundingBox;
        private boolean beginEqualsEnd;

        public RuntimeBetterPlaceAnimation() {
            super(BetterPlaceAnimation.this);
            this.beginEqualsEnd = false;
        }

        protected Vector3d getPositionEnd() {
            if (this.m_subjectBoundingBox == null) {
                this.m_subjectBoundingBox = this.m_subject.getBoundingBox();
                if (this.m_subjectBoundingBox.getMaximum() == null) {
                    this.m_subjectBoundingBox = new Box(this.m_subject.getPosition(this.m_subject), this.m_subject.getPosition(this.m_subject));
                }
            }
            if (this.m_asSeenByBoundingBox == null) {
                this.m_asSeenByBoundingBox = this.m_asSeenBy.getBoundingBox();
                if (this.m_asSeenByBoundingBox.getMaximum() == null) {
                    this.m_asSeenByBoundingBox = new Box(this.m_asSeenBy.getPosition(this.m_asSeenBy), this.m_asSeenBy.getPosition(this.m_asSeenBy));
                }
            }
            SpatialRelation sv = BetterPlaceAnimation.this.spatialRelation.getSpatialRelationValue();
            Vector3d v = sv.getPlaceVector(BetterPlaceAnimation.this.amount.doubleValue(), this.m_subjectBoundingBox, this.m_asSeenByBoundingBox);
            return v;
        }

        @Override
        public void prologue(double t) {
            this.beginEqualsEnd = false;
            this.m_subject = BetterPlaceAnimation.this.subject.getTransformableValue();
            this.m_asSeenBy = BetterPlaceAnimation.this.asSeenBy.getReferenceFrameValue();
            if (this.m_asSeenBy == null) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("needs_something_or_someone_to_move_to_"), null, BetterPlaceAnimation.this.asSeenBy);
            }
            if (this.m_subject == this.m_asSeenBy) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("can_t_move_to_") + this.m_subject.name.getStringValue() + ".", this.getCurrentStack(), BetterPlaceAnimation.this.asSeenBy);
            }
            if (this.m_subject.isAncestorOf(this.m_asSeenBy)) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("can_t_move_to_a_part_of_itself"), this.getCurrentStack(), BetterPlaceAnimation.this.asSeenBy);
            }
            Matrix44 pov = BetterPlaceAnimation.this.asSeenBy.getReferenceFrameValue().getPointOfView();
            Vector3d posAbs = this.getPositionEnd();
            Vector3 curPos = this.m_subject.getPosition();
            this.m_subject.setPositionRightNow(posAbs, this.m_asSeenBy);
            Matrix33 paMatrix = this.m_subject.calculatePointAt(this.m_asSeenBy, null, new Vector3d(0.0, 1.0, 0.0), null, true);
            this.m_subject.setPositionRightNow(curPos);
            pov.set(paMatrix);
            pov.setRow(3, posAbs.x, posAbs.y, posAbs.z, 1.0);
            BetterPlaceAnimation.this.pointOfView.set(pov);
            if (curPos.equals((Tuple3d)posAbs)) {
                this.beginEqualsEnd = true;
            }
            super.prologue(t);
        }

        @Override
        public void update(double t) {
            if (!this.beginEqualsEnd) {
                super.update(t);
            }
        }

        @Override
        protected boolean affectQuaternion() {
            return false;
        }

        protected boolean followHermiteCubic() {
            return true;
        }

        protected boolean followHermiteCubicOrientation() {
            return true;
        }
    }
}

