/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.property.Vector3Property;
import edu.cmu.cs.stage3.alice.core.response.OrientationAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Quaternion;
import javax.vecmath.Vector3d;

public abstract class AbstractPointAtAnimation
extends OrientationAnimation {
    public final ReferenceFrameProperty target = new ReferenceFrameProperty((Element)this, "target", null);
    public final Vector3Property offset = new Vector3Property(this, "offset", null);
    public final Vector3Property upGuide = new Vector3Property(this, "upGuide", null);

    public abstract class RuntimeAbstractPointAtAnimation
    extends OrientationAnimation.RuntimeOrientationAnimation {
        protected ReferenceFrame m_target;
        protected Vector3d m_offset;
        protected Vector3d m_upGuide;
        protected boolean m_onlyAffectYaw;

        public RuntimeAbstractPointAtAnimation() {
            super(AbstractPointAtAnimation.this);
        }

        protected abstract boolean onlyAffectYaw();

        protected ReferenceFrame getTarget() {
            return AbstractPointAtAnimation.this.target.getReferenceFrameValue();
        }

        protected Transformable getSubject() {
            return AbstractPointAtAnimation.this.subject.getTransformableValue();
        }

        protected Vector3d getOffset() {
            return AbstractPointAtAnimation.this.offset.getVector3Value();
        }

        protected Vector3d getUpguide() {
            return AbstractPointAtAnimation.this.upGuide.getVector3Value();
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_target = this.getTarget();
            this.m_offset = this.getOffset();
            this.m_upGuide = this.getUpguide();
            this.m_onlyAffectYaw = this.onlyAffectYaw();
            if (this.m_target == null) {
                throw new SimulationPropertyException(Messages.getString("target_value_must_not_be_null_"), null, AbstractPointAtAnimation.this.target);
            }
            if (this.m_target == this.m_subject) {
                throw new SimulationPropertyException(Messages.getString("target_value_must_not_be_equal_to_the_subject_value_"), this.getCurrentStack(), AbstractPointAtAnimation.this.target);
            }
            if (this.m_onlyAffectYaw && this.m_subject.isAncestorOf(this.m_target)) {
                throw new SimulationPropertyException(String.valueOf(this.m_subject.name.getStringValue()) + " " + Messages.getString("can_t_turn_to_face_or_turn_away_from_a_part_of_itself_"), this.getCurrentStack(), AbstractPointAtAnimation.this.target);
            }
        }

        protected Matrix33 getTargetMatrix33() {
            return this.m_subject.calculatePointAt(this.m_target, this.m_offset, this.m_upGuide, this.m_asSeenBy, this.m_onlyAffectYaw);
        }

        @Override
        protected Quaternion getTargetQuaternion() {
            return this.getTargetMatrix33().getQuaternion();
        }

        @Override
        public void update(double t) {
            this.markTargetQuaternionDirty();
            super.update(t);
        }
    }
}

