/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Vector3;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class AbstractMoveInDirectionOfAnimation
extends TransformAnimation {
    public final ReferenceFrameProperty target = new ReferenceFrameProperty((Element)this, "target", null);
    public final NumberProperty amount = new NumberProperty(this, "amount", new Double(1.0));

    public abstract class RuntimeAbstractMoveInDirectionOfAnimationAnimation
    extends TransformAnimation.RuntimeTransformAnimation {
        private ReferenceFrame m_target;
        private Vector3d m_vector;
        private Vector3d m_vectorPrev;

        protected abstract double getActualAmountValue();

        protected Vector3d getVector() {
            double amountValue = this.getActualAmountValue();
            if (!Double.isNaN(amountValue)) {
                Vector3 v = this.m_target.getPosition(this.m_subject);
                double length = MathUtilities.getLength(v);
                if (length > 0.0) {
                    v.scale(amountValue / length);
                } else {
                    v.set(0.0, 0.0, amountValue);
                }
                return v;
            }
            return new Vector3d();
        }

        @Override
        public void prologue(double t) {
            super.prologue(t);
            this.m_target = AbstractMoveInDirectionOfAnimation.this.target.getReferenceFrameValue();
            if (this.m_target == null) {
                throw new SimulationPropertyException(Messages.getString("target_must_not_be_null_"), this.getCurrentStack(), AbstractMoveInDirectionOfAnimation.this.target);
            }
            this.m_vectorPrev = new Vector3d();
            this.m_vector = this.getVector();
        }

        @Override
        public void update(double t) {
            super.update(t);
            Vector3d delta = MathUtilities.subtract(MathUtilities.multiply(this.m_vector, this.getPortion(t)), this.m_vectorPrev);
            this.m_subject.moveRightNow(delta, this.m_asSeenBy);
            this.m_vectorPrev.add((Tuple3d)delta);
        }
    }
}

