/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.criterion.ElementWithPropertyNameValueCriterion;
import edu.cmu.cs.stage3.alice.core.property.ColorProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.response.Animation;
import edu.cmu.cs.stage3.math.Interpolator;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;

public class AbstractFadeAnimation
extends Animation {
    public final ReferenceFrameProperty subject = new ReferenceFrameProperty((Element)this, "subject", null);
    protected static Color atmosphereColor = new Color(72, 72, 72);
    protected static Color ambientLightColor = new Color(74, 125, 204);
    protected static boolean currentlyBlack = false;
    protected static Vector properties = new Vector();
    protected static Vector origPropertyValues = new Vector();
    protected static Vector specularProperties = new Vector();
    protected static Vector origSpecularValues = new Vector();
    protected static Vector lightProperties = new Vector();
    protected static Vector origLightValues = new Vector();

    public abstract class RuntimeAbstractFadeAnimation
    extends Animation.RuntimeAnimation {
        protected ColorProperty m_atmosphereColorProp = null;
        protected ColorProperty m_ambientLightColorProp = null;
        protected Vector m_beginPropColors = new Vector();
        protected Vector m_endPropColors = new Vector();
        protected Vector m_beginSpecularColors = new Vector();
        protected Vector m_endSpecularColors = new Vector();
        protected Vector m_beginPropBrightness = new Vector();
        protected Vector m_endPropBrightness = new Vector();
        protected Color m_beginAtmosphereColor = null;
        protected Color m_endAtmosphereColor = null;
        protected Color m_beginAmbientLightColor = null;
        protected Color m_endAmbientLightColor = null;
        protected double m_beginBrightness = -1.0;
        protected double m_endBrightness = -1.0;

        protected abstract boolean endsBlack();

        @Override
        public void prologue(double t) {
            super.prologue(t);
            World world = AbstractFadeAnimation.this.getWorld();
            this.m_atmosphereColorProp = (ColorProperty)world.getPropertyNamed("atmosphereColor");
            this.m_ambientLightColorProp = (ColorProperty)world.getPropertyNamed("ambientLightColor");
            if (!currentlyBlack) {
                ColorProperty emissColorProp;
                String key;
                atmosphereColor = this.m_atmosphereColorProp.getColorValue().createAWTColor();
                ambientLightColor = this.m_ambientLightColorProp.getColorValue().createAWTColor();
                properties.clear();
                origPropertyValues.clear();
                Element[] els = world.search(new ElementWithPropertyNameValueCriterion("emissiveColor", new edu.cmu.cs.stage3.alice.scenegraph.Color(0.0f, 0.0f, 0.0f), false));
                int i = 0;
                while (i < els.length) {
                    key = els[i].getKey();
                    emissColorProp = (ColorProperty)els[i].getPropertyNamed("emissiveColor");
                    properties.addElement(emissColorProp);
                    origPropertyValues.addElement(emissColorProp.getColorValue().createAWTColor());
                    ++i;
                }
                specularProperties.clear();
                origSpecularValues.clear();
                els = world.search(new ElementWithPropertyNameValueCriterion("specularHighlightColor", new edu.cmu.cs.stage3.alice.scenegraph.Color(0.0f, 0.0f, 0.0f), false));
                i = 0;
                while (i < els.length) {
                    key = els[i].getKey();
                    emissColorProp = (ColorProperty)els[i].getPropertyNamed("specularHighlightColor");
                    properties.addElement(emissColorProp);
                    origPropertyValues.addElement(emissColorProp.getColorValue().createAWTColor());
                    ++i;
                }
                lightProperties.clear();
                origLightValues.clear();
                els = world.search(new ElementWithPropertyNameValueCriterion("brightness", new Double(0.0), false));
                i = 0;
                while (i < els.length) {
                    NumberProperty brightnessProp = (NumberProperty)els[i].getPropertyNamed("brightness");
                    lightProperties.addElement(brightnessProp);
                    origLightValues.addElement(brightnessProp.getNumberValue());
                    ++i;
                }
            }
            this.m_beginPropColors.clear();
            this.m_endPropColors.clear();
            this.m_beginSpecularColors.clear();
            this.m_endSpecularColors.clear();
            this.m_beginPropBrightness.clear();
            this.m_endPropBrightness.clear();
            if (this.endsBlack()) {
                this.m_beginAtmosphereColor = this.m_atmosphereColorProp.getColorValue().createAWTColor();
                this.m_endAtmosphereColor = new Color(0, 0, 0);
                this.m_beginAmbientLightColor = this.m_atmosphereColorProp.getColorValue().createAWTColor();
                this.m_endAmbientLightColor = new Color(0, 0, 0);
                int i = 0;
                while (i < properties.size()) {
                    ColorProperty colorProp = (ColorProperty)properties.elementAt(i);
                    this.m_beginPropColors.addElement(colorProp.getColorValue().createAWTColor());
                    this.m_endPropColors.addElement(new Color(0, 0, 0));
                    ++i;
                }
                i = 0;
                while (i < specularProperties.size()) {
                    ColorProperty colorProp = (ColorProperty)specularProperties.elementAt(i);
                    this.m_beginSpecularColors.addElement(colorProp.getColorValue().createAWTColor());
                    this.m_endSpecularColors.addElement(new Color(0, 0, 0));
                    ++i;
                }
                i = 0;
                while (i < lightProperties.size()) {
                    NumberProperty numberProp = (NumberProperty)lightProperties.elementAt(i);
                    this.m_beginPropBrightness.addElement(numberProp.getNumberValue());
                    this.m_endPropBrightness.addElement(new Double(0.0));
                    ++i;
                }
            } else {
                this.m_beginAtmosphereColor = this.m_atmosphereColorProp.getColorValue().createAWTColor();
                this.m_endAtmosphereColor = atmosphereColor;
                this.m_beginAmbientLightColor = this.m_ambientLightColorProp.getColorValue().createAWTColor();
                this.m_endAmbientLightColor = ambientLightColor;
                int i = 0;
                while (i < properties.size()) {
                    ColorProperty colorProp = (ColorProperty)properties.elementAt(i);
                    this.m_beginPropColors.addElement(colorProp.getColorValue().createAWTColor());
                    this.m_endPropColors.addElement(origPropertyValues.elementAt(i));
                    ++i;
                }
                i = 0;
                while (i < specularProperties.size()) {
                    ColorProperty colorProp = (ColorProperty)specularProperties.elementAt(i);
                    this.m_beginSpecularColors.addElement(colorProp.getColorValue().createAWTColor());
                    this.m_endSpecularColors.addElement(origSpecularValues.elementAt(i));
                    ++i;
                }
                i = 0;
                while (i < lightProperties.size()) {
                    NumberProperty numberProp = (NumberProperty)lightProperties.elementAt(i);
                    this.m_beginPropBrightness.addElement(numberProp.getNumberValue());
                    this.m_endPropBrightness.addElement(origLightValues.elementAt(i));
                    ++i;
                }
            }
        }

        @Override
        public void update(double t) {
            Color endColor;
            Color beginColor;
            ColorProperty colorProp;
            super.update(t);
            Serializable value = this.m_beginAtmosphereColor != null && this.m_endAtmosphereColor != null ? Interpolator.interpolate(this.m_beginAtmosphereColor, this.m_endAtmosphereColor, this.getPortion(t)) : this.m_endAtmosphereColor;
            this.m_atmosphereColorProp.set(new edu.cmu.cs.stage3.alice.scenegraph.Color((Color)value));
            value = this.m_beginAmbientLightColor != null && this.m_endAmbientLightColor != null ? Interpolator.interpolate(this.m_beginAmbientLightColor, this.m_endAmbientLightColor, this.getPortion(t)) : this.m_endAmbientLightColor;
            this.m_ambientLightColorProp.set(new edu.cmu.cs.stage3.alice.scenegraph.Color((Color)value));
            int i = 0;
            while (i < properties.size()) {
                colorProp = (ColorProperty)properties.elementAt(i);
                beginColor = (Color)this.m_beginPropColors.elementAt(i);
                endColor = (Color)this.m_endPropColors.elementAt(i);
                value = beginColor != null && endColor != null ? Interpolator.interpolate(beginColor, endColor, this.getPortion(t)) : endColor;
                colorProp.set(new edu.cmu.cs.stage3.alice.scenegraph.Color((Color)value));
                ++i;
            }
            i = 0;
            while (i < specularProperties.size()) {
                colorProp = (ColorProperty)specularProperties.elementAt(i);
                beginColor = (Color)this.m_beginSpecularColors.elementAt(i);
                endColor = (Color)this.m_endSpecularColors.elementAt(i);
                value = beginColor != null && endColor != null ? Interpolator.interpolate(beginColor, endColor, this.getPortion(t)) : endColor;
                colorProp.set(new edu.cmu.cs.stage3.alice.scenegraph.Color((Color)value));
                ++i;
            }
            i = 0;
            while (i < lightProperties.size()) {
                NumberProperty numberProp = (NumberProperty)lightProperties.elementAt(i);
                Double beginBrightness = (Double)this.m_beginPropBrightness.elementAt(i);
                Double endBrightness = (Double)this.m_endPropBrightness.elementAt(i);
                value = beginBrightness != -1.0 && endBrightness != -1.0 ? (Number)Interpolator.interpolate(beginBrightness, endBrightness, this.getPortion(t)) : (Number)endBrightness;
                numberProp.set(value);
                ++i;
            }
        }

        @Override
        public void epilogue(double t) {
            super.epilogue(t);
            currentlyBlack = this.endsBlack();
        }
    }
}

