/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.SimulationPropertyException;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.bubble.Bubble;
import edu.cmu.cs.stage3.alice.core.property.ColorProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Font;

public abstract class AbstractBubbleAnimation
extends Response {
    public final TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public final StringProperty what = new StringProperty(this, "what", "hello");
    public final ColorProperty bubbleColor = new ColorProperty(this, "bubbleColor", Color.WHITE);
    public final ColorProperty textColor = new ColorProperty(this, "textColor", Color.BLACK);
    public final NumberProperty fontSize = new NumberProperty(this, "fontSize", new Integer(20));
    public final StringProperty fontName = new StringProperty(this, "fontName", "Arial");
    private World m_world;

    public abstract class RuntimeAbstractBubbleAnimation
    extends Response.RuntimeResponse {
        private World m_world;
        private Bubble m_bubble;

        protected abstract Bubble createBubble();

        @Override
        public void prologue(double t) {
            super.prologue(t);
            Transformable subjectValue = AbstractBubbleAnimation.this.subject.getTransformableValue();
            if (subjectValue == null) {
                throw new SimulationPropertyException(Messages.getString("subject_must_not_be_null_"), this.getCurrentStack(), AbstractBubbleAnimation.this.subject);
            }
            String whatValue = AbstractBubbleAnimation.this.what.getStringValue();
            if (whatValue == null || whatValue.length() == 0) {
                throw new SimulationPropertyException(Messages.getString("what_must_not_be_null_"), this.getCurrentStack(), AbstractBubbleAnimation.this.what);
            }
            if (this.m_bubble == null) {
                this.m_bubble = this.createBubble();
            }
            this.m_bubble.setReferenceFrame(subjectValue);
            this.m_bubble.setOffsetFromReferenceFrame(subjectValue.getBoundingBox().getCenterOfTopFace());
            this.m_bubble.setText(whatValue);
            this.m_bubble.setFont(new Font(AbstractBubbleAnimation.this.fontName.getStringValue(), 0, AbstractBubbleAnimation.this.fontSize.intValue()));
            this.m_bubble.setBackgroundColor(AbstractBubbleAnimation.this.bubbleColor.getColorValue().createAWTColor());
            this.m_bubble.setForegroundColor(AbstractBubbleAnimation.this.textColor.getColorValue().createAWTColor());
            this.m_bubble.setIsShowing(true);
            this.m_world = AbstractBubbleAnimation.this.getWorld();
            if (this.m_world != null) {
                this.m_world.bubbles.add(this.m_bubble);
            }
        }

        @Override
        public void epilogue(double t) {
            if (this.m_bubble != null) {
                this.m_bubble.setIsShowing(false);
                if (this.m_world != null) {
                    this.m_world.bubbles.remove(this.m_bubble);
                    this.m_world = null;
                }
            }
            super.epilogue(t);
        }
    }
}

